/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.tool.checkstyle;

import com.puppycrawl.tools.checkstyle.api.AbstractCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.FileContents;
import com.puppycrawl.tools.checkstyle.api.FullIdent;
import com.puppycrawl.tools.checkstyle.api.TextBlock;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class SinceFormatCheck
extends AbstractCheck {
    private static final Pattern VALID_VERSION_FORMAT = Pattern.compile("\\d+\\.\\d+\\.\\d+(RC\\d)?");
    private String packageName;
    private String classOrInterfaceName;

    public int[] getDefaultTokens() {
        return new int[]{16, 15, 14, 9};
    }

    public int[] getAcceptableTokens() {
        return this.getDefaultTokens();
    }

    public int[] getRequiredTokens() {
        return this.getDefaultTokens();
    }

    public void visitToken(DetailAST ast) {
        switch (ast.getType()) {
            case 16: {
                FullIdent ident = FullIdent.createFullIdent((DetailAST)ast.getLastChild().getPreviousSibling());
                this.packageName = ident.getText();
                return;
            }
            case 14: 
            case 15: {
                this.classOrInterfaceName = ast.findFirstToken(58).getText();
            }
        }
        String elementName = ast.findFirstToken(58).getText();
        FileContents contents = this.getFileContents();
        TextBlock javadoc = contents.getJavadocBefore(ast.getLineNo());
        if (javadoc != null) {
            for (String javadocLine : javadoc.getText()) {
                String text;
                int pos = javadocLine.indexOf("@since");
                if (pos <= -1 || !this.checkOnlyOneVersion(text = javadocLine.substring(pos + "@since".length() + 1), ast, elementName)) continue;
                this.checkVersionFormat(text, ast, elementName);
            }
        }
    }

    private void checkVersionFormat(String version, DetailAST ast, String elementName) {
        String majorVersionString = StringUtils.substringBefore((String)version, (int)46);
        int majorVersion = Integer.parseInt(majorVersionString);
        if (majorVersion >= 16 && !VALID_VERSION_FORMAT.matcher(version).matches()) {
            this.log(ast.getLineNo(), ast.getColumnNo(), String.format("The format of the version is <major>.<minor>.<bugfix>[RC<rc index>] for [%s]. Got [%s].", this.computeElementName(elementName), version), new Object[0]);
        }
    }

    private boolean checkOnlyOneVersion(String text, DetailAST ast, String elementName) {
        if (StringUtils.containsAny((CharSequence)text, (char[])new char[]{',', '/', '\\', ';', ':', '+'})) {
            this.log(ast.getLineNo(), ast.getColumnNo(), String.format("There must be only a single version per @since tag for [%s]. Got [%s].", this.computeElementName(elementName), text), new Object[0]);
            return false;
        }
        return true;
    }

    private String computeElementName(String annotatedElementName) {
        return String.format("%s.%s%s", this.packageName, this.classOrInterfaceName, annotatedElementName.equals(this.classOrInterfaceName) ? "" : "." + annotatedElementName + "()");
    }
}

