/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.tool.checkstyle;

import com.puppycrawl.tools.checkstyle.api.AbstractCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.FullIdent;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.annotation.Annotation;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;

public class ComponentAnnotationCheck
extends AbstractCheck {
    private static final String COMPONENTS_TXT_LOCATION = "META-INF/components.txt";
    private static final String COMPONENT_CLASS_NAME = "org.xwiki.component.annotation.Component";
    private static final String SINGLETON_CLASS_NAME = "javax.inject.Singleton";
    private static final String INSTANTIATION_STRATEGY_CLASS_NAME = "org.xwiki.component.annotation.InstantiationStrategy";
    private String packageName;
    private String className;
    private List<String> registeredComponentNames;
    private URL componentsDeclarationLocation;
    private Class<? extends Annotation> componentAnnotationClass;
    private Class<? extends Annotation> singletonAnnotationClass;
    private Class<? extends Annotation> instantiationStrategyAnnotationClass;

    public int[] getDefaultTokens() {
        return new int[]{16, 14};
    }

    public int[] getAcceptableTokens() {
        return this.getDefaultTokens();
    }

    public int[] getRequiredTokens() {
        return this.getDefaultTokens();
    }

    public void init() {
        super.init();
        this.componentAnnotationClass = this.loadAnnotationClass(COMPONENT_CLASS_NAME);
        this.instantiationStrategyAnnotationClass = this.loadAnnotationClass(INSTANTIATION_STRATEGY_CLASS_NAME);
        this.singletonAnnotationClass = this.loadAnnotationClass(SINGLETON_CLASS_NAME);
    }

    public void visitToken(DetailAST ast) {
        Class<?> componentClass;
        if (this.componentAnnotationClass == null || this.instantiationStrategyAnnotationClass == null || this.singletonAnnotationClass == null) {
            return;
        }
        switch (ast.getType()) {
            case 16: {
                FullIdent ident = FullIdent.createFullIdent((DetailAST)ast.getLastChild().getPreviousSibling());
                this.packageName = ident.getText();
                return;
            }
            case 14: {
                if (ast.getParent() == null) {
                    this.className = ast.findFirstToken(58).getText();
                    break;
                }
                return;
            }
        }
        try {
            componentClass = Thread.currentThread().getContextClassLoader().loadClass(this.getFullClassName());
        }
        catch (ClassNotFoundException e) {
            this.log(ast.getLineNo(), ast.getColumnNo(), String.format("Failed to load class in package [%s]: [%s]", this.packageName, this.getThrowableString(e)), new Object[0]);
            return;
        }
        Annotation componentAnnotation = componentClass.getAnnotation(this.componentAnnotationClass);
        if (componentAnnotation != null) {
            if (this.registeredComponentNames == null) {
                this.registeredComponentNames = this.parseComponentsTxtFile(ast);
            }
            if (!this.isStaticRegistration(componentAnnotation)) {
                if (this.registeredComponentNames.contains(this.getFullClassName())) {
                    this.log(ast.getLineNo(), ast.getColumnNo(), String.format("Component [%s] is declared in [%s] but it is also declared with a \"staticRegistration\" parameter with a [false] value, e.g. \"@Component(staticRegistration = false\". You need to fix that!", this.getFullClassName(), this.componentsDeclarationLocation), new Object[0]);
                }
            } else if (!this.registeredComponentNames.contains(this.getFullClassName())) {
                this.log(ast.getLineNo(), ast.getColumnNo(), String.format("Component [%s] is not declared in [%s]! Consider adding it or if it is normal use the \"staticRegistration\" parameter as in \"@Component(staticRegistration = false)\"", this.getFullClassName(), this.componentsDeclarationLocation), new Object[0]);
            }
            Annotation instantiationStrategyAnnotation = componentClass.getAnnotation(this.instantiationStrategyAnnotationClass);
            Annotation singletonAnnotation = componentClass.getAnnotation(this.singletonAnnotationClass);
            if (instantiationStrategyAnnotation == null && singletonAnnotation == null) {
                this.log(ast.getLineNo(), ast.getColumnNo(), String.format("Component class [%s] must have either the [%s] or the [%s] annotation defined on it.", this.getFullClassName(), SINGLETON_CLASS_NAME, INSTANTIATION_STRATEGY_CLASS_NAME), new Object[0]);
            }
        }
    }

    private boolean isStaticRegistration(Annotation componentAnnotation) {
        boolean isStaticRegistration = true;
        try {
            isStaticRegistration = (Boolean)componentAnnotation.getClass().getMethod("staticRegistration", new Class[0]).invoke((Object)componentAnnotation, new Object[0]);
        }
        catch (Exception e) {
            this.log(1, 1, String.format("Failed to find out if Component annotation is statically registered or not! Reason: [%s]", this.getThrowableString(e)), new Object[0]);
        }
        return isStaticRegistration;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List<String> parseComponentsTxtFile(DetailAST ast) {
        ArrayList<String> results = new ArrayList<String>();
        try {
            Enumeration<URL> urls = Thread.currentThread().getContextClassLoader().getResources(COMPONENTS_TXT_LOCATION);
            while (urls.hasMoreElements()) {
                URL url = urls.nextElement();
                if (!url.getProtocol().equals("file")) continue;
                this.componentsDeclarationLocation = url;
                break;
            }
        }
        catch (Exception e) {
            this.log(1, 1, String.format("Failed to locate [%s]. Error [%s]", COMPONENTS_TXT_LOCATION, this.getThrowableString(e)), new Object[0]);
            return Collections.emptyList();
        }
        try (BufferedReader in = new BufferedReader(new InputStreamReader(this.componentsDeclarationLocation.openStream()));){
            String inputLine;
            while ((inputLine = in.readLine()) != null) {
                if (inputLine.trim().length() <= 0) continue;
                try {
                    String[] chunks = inputLine.split(":");
                    if (chunks.length > 1) {
                        results.add(chunks[1]);
                        continue;
                    }
                    results.add(chunks[0]);
                }
                catch (Exception e) {
                    this.log(ast.getLineNo(), ast.getColumnNo(), String.format("Invalid format [%s] in [%s]", inputLine, this.componentsDeclarationLocation), new Object[0]);
                }
            }
            return results;
        }
        catch (Exception e) {
            this.log(ast.getLineNo(), ast.getColumnNo(), String.format("There is no [%s] file and thus Component [%s] isn't declared! Consider adding a components.txt file or if it is normal use the \"staticRegistration\" parameter as in \"@Component(staticRegistration = false)\"", this.componentsDeclarationLocation, this.getFullClassName()), new Object[0]);
        }
        return results;
    }

    private String getFullClassName() {
        return String.format("%s.%s", this.packageName, this.className);
    }

    private String getThrowableString(Throwable t) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter((Writer)sw, true);
        t.printStackTrace(pw);
        return sw.getBuffer().toString();
    }

    private Class<? extends Annotation> loadAnnotationClass(String annotationClassString) {
        Class<Annotation> annotationClass;
        try {
            annotationClass = Thread.currentThread().getContextClassLoader().loadClass(annotationClassString).asSubclass(Annotation.class);
        }
        catch (Exception e) {
            annotationClass = null;
        }
        return annotationClass;
    }
}

