/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.test.junit5;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import org.apache.commons.io.output.TeeOutputStream;
import org.junit.platform.engine.TestExecutionResult;
import org.junit.platform.launcher.TestIdentifier;
import org.xwiki.test.junit5.AbstractTestExecutionListener;

public abstract class AbstractConsoleTestExecutionListener
extends AbstractTestExecutionListener {
    private PrintStream savedOut;
    private PrintStream savedErr;
    private ByteArrayOutputStream collectingContentStream;

    @Override
    protected void executionStartedInternal(TestIdentifier testIdentifier) {
        if (testIdentifier.getParentId().isPresent()) {
            return;
        }
        this.savedOut = System.out;
        this.savedErr = System.err;
        this.collectingContentStream = new ByteArrayOutputStream();
        System.setOut(new PrintStream((OutputStream)new TeeOutputStream((OutputStream)this.collectingContentStream, (OutputStream)this.savedOut)));
        System.setErr(new PrintStream((OutputStream)new TeeOutputStream((OutputStream)this.collectingContentStream, (OutputStream)this.savedErr)));
    }

    @Override
    protected void executionFinishedInternal(TestIdentifier testIdentifier, TestExecutionResult testExecutionResult) {
        if (!testIdentifier.getParentId().isPresent()) {
            System.setOut(this.savedOut);
            System.setOut(this.savedErr);
            String outputContent = this.collectingContentStream.toString();
            this.validateOutputForTest(outputContent, testIdentifier);
        } else if (testIdentifier.isTest() && testExecutionResult.getStatus().equals((Object)TestExecutionResult.Status.SUCCESSFUL)) {
            String outputContent = this.collectingContentStream.toString();
            this.validateOutputForTest(outputContent, testIdentifier);
        }
    }

    protected abstract void validateOutputForTest(String var1, TestIdentifier var2);
}

