/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.test.internal;

import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import org.xwiki.component.annotation.ComponentAnnotationLoader;
import org.xwiki.component.annotation.ComponentDeclaration;
import org.xwiki.component.descriptor.ComponentDescriptor;
import org.xwiki.component.descriptor.DefaultComponentDescriptor;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.configuration.internal.MemoryConfigurationSource;
import org.xwiki.test.annotation.AllComponents;
import org.xwiki.test.annotation.ComponentList;
import org.xwiki.test.internal.MockConfigurationSource;
import org.xwiki.test.internal.TestComponentAnnotationLoader;

public class ComponentRegistrator {
    private ComponentAnnotationLoader loader = new TestComponentAnnotationLoader();

    public void registerComponent(Type roleType, Object instance, ComponentManager componentManager) throws Exception {
        this.registerComponent(roleType, null, instance, componentManager);
    }

    public void registerComponent(Type roleType, String roleHint, Object instance, ComponentManager componentManager) throws Exception {
        DefaultComponentDescriptor descriptor = new DefaultComponentDescriptor();
        descriptor.setRoleType(roleType);
        if (roleHint != null) {
            descriptor.setRoleHint(roleHint);
        }
        descriptor.setImplementation(instance.getClass());
        componentManager.registerComponent((ComponentDescriptor)descriptor, instance);
    }

    public void registerComponent(Class<?> componentImplementation, ComponentManager componentManager) throws Exception {
        List descriptors = this.loader.getComponentsDescriptors(componentImplementation);
        for (ComponentDescriptor descriptor : descriptors) {
            componentManager.registerComponent(descriptor);
        }
    }

    public void registerComponentIfDontExist(Class<?> componentImplementation, ComponentManager componentManager) throws Exception {
        List descriptors = this.loader.getComponentsDescriptors(componentImplementation);
        for (ComponentDescriptor descriptor : descriptors) {
            if (componentManager.hasComponent(descriptor.getRoleType(), descriptor.getRoleHint())) continue;
            componentManager.registerComponent(descriptor);
        }
    }

    public void registerComponents(Class<?> testClass, ComponentManager componentManager) throws IOException {
        AllComponents allComponentsAnnotation = testClass.getAnnotation(AllComponents.class);
        if (allComponentsAnnotation != null) {
            ArrayList<String> excludedComponentTypes = new ArrayList<String>();
            for (Class<?> excludedComponentType : allComponentsAnnotation.excludes()) {
                excludedComponentTypes.add(excludedComponentType.getTypeName());
            }
            List componentDeclarations = this.loader.getDeclaredComponents(testClass.getClassLoader(), "META-INF/components.txt");
            componentDeclarations.removeIf(i -> excludedComponentTypes.contains(i.getImplementationClassName()));
            this.loader.initialize(componentManager, testClass.getClassLoader(), componentDeclarations);
        } else {
            List<ComponentDeclaration> componentDeclarations = this.getComponentDeclarationsFromAnnotation(testClass.getAnnotations(), new ArrayList<Annotation>());
            if (!componentDeclarations.isEmpty()) {
                this.loader.initialize(componentManager, testClass.getClassLoader(), componentDeclarations);
            }
        }
    }

    private List<ComponentDeclaration> getComponentDeclarationsFromAnnotation(Annotation[] annotations, List<Annotation> alreadyProcessedAnnotations) {
        LinkedHashSet<ComponentDeclaration> componentDeclarations = new LinkedHashSet<ComponentDeclaration>();
        for (Annotation annotation : annotations) {
            if (annotation instanceof ComponentList) {
                ComponentList componentListAnnotation = (ComponentList)annotation;
                for (Class<?> componentClass : componentListAnnotation.value()) {
                    componentDeclarations.add(new ComponentDeclaration(componentClass.getName()));
                }
                continue;
            }
            if (alreadyProcessedAnnotations.contains(annotation)) continue;
            alreadyProcessedAnnotations.add(annotation);
            componentDeclarations.addAll(this.getComponentDeclarationsFromAnnotation(annotation.annotationType().getAnnotations(), alreadyProcessedAnnotations));
        }
        return new ArrayList<ComponentDeclaration>(componentDeclarations);
    }

    public MemoryConfigurationSource registerMemoryConfigurationSource(ComponentManager componentManager) throws Exception {
        MockConfigurationSource configurationSource = new MockConfigurationSource();
        componentManager.registerComponent(MockConfigurationSource.getDescriptor(null), (Object)configurationSource);
        componentManager.registerComponent(MockConfigurationSource.getDescriptor("xwikiproperties"), (Object)configurationSource);
        componentManager.registerComponent(MockConfigurationSource.getDescriptor("all"), (Object)configurationSource);
        return configurationSource;
    }
}

