/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.test.junit5.mockito;

import java.lang.reflect.Field;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import java.util.List;
import javax.inject.Named;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolutionException;
import org.junit.jupiter.api.extension.ParameterResolver;
import org.junit.jupiter.api.extension.TestInstancePostProcessor;
import org.mockito.MockitoAnnotations;
import org.xwiki.component.annotation.ComponentAnnotationLoader;
import org.xwiki.component.descriptor.ComponentDescriptor;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.component.util.ReflectionUtils;
import org.xwiki.test.junit5.mockito.InjectComponentManager;
import org.xwiki.test.junit5.mockito.InjectMockComponents;
import org.xwiki.test.junit5.mockito.MockComponent;
import org.xwiki.test.mockito.MockitoComponentManager;
import org.xwiki.test.mockito.MockitoComponentMocker;

public class MockitoComponentManagerExtension
implements TestInstancePostProcessor,
AfterEachCallback,
ParameterResolver {
    private static final ExtensionContext.Namespace NAMESPACE = ExtensionContext.Namespace.create((Object[])new Object[]{MockitoComponentManagerExtension.class});
    private static final ComponentAnnotationLoader LOADER = new ComponentAnnotationLoader();

    public void postProcessTestInstance(Object testInstance, ExtensionContext context) throws Exception {
        boolean initializeCM;
        this.removeComponentManager(context);
        MockitoComponentManager mcm = this.loadComponentManager(context);
        boolean bl = initializeCM = mcm == null;
        if (initializeCM) {
            mcm = new MockitoComponentManager();
            this.saveComponentManager(context, mcm);
        }
        for (Field field : ReflectionUtils.getAllFields(testInstance.getClass())) {
            if (!field.isAnnotationPresent(InjectComponentManager.class)) continue;
            ReflectionUtils.setFieldValue((Object)testInstance, (String)field.getName(), (Object)((Object)mcm));
        }
        for (Field field : ReflectionUtils.getAllFields(testInstance.getClass())) {
            if (!field.isAnnotationPresent(MockComponent.class)) continue;
            Named namedAnnotation = field.getAnnotation(Named.class);
            Object mockComponent = namedAnnotation != null ? mcm.registerMockComponent(field.getGenericType(), namedAnnotation.value()) : mcm.registerMockComponent(field.getGenericType());
            ReflectionUtils.setFieldValue((Object)testInstance, (String)field.getName(), mockComponent);
        }
        if (initializeCM) {
            this.initializeMockitoComponentManager(testInstance, mcm, context);
        }
        for (Field field : ReflectionUtils.getAllFields(testInstance.getClass())) {
            InjectMockComponents annotation = field.getAnnotation(InjectMockComponents.class);
            if (annotation == null) continue;
            this.processInjectMockComponents(testInstance, field, annotation, mcm);
        }
        MockitoAnnotations.initMocks((Object)testInstance);
    }

    protected void processInjectMockComponents(Object testInstance, Field field, InjectMockComponents annotation, MockitoComponentManager mcm) throws Exception {
        if (field.getType().isInterface()) {
            throw new Exception(String.format("The type of the field [%s] annotated with @%s cannot be an interface.", InjectMockComponents.class.getSimpleName(), field.getName()));
        }
        List descriptors = LOADER.getComponentsDescriptors(field.getType());
        ComponentDescriptor<?> descriptor = this.getDescriptor(annotation.role(), descriptors, field);
        MockitoComponentMocker mocker = new MockitoComponentMocker(mcm, field.getType(), descriptor.getRoleType(), descriptor.getRoleHint());
        mocker.mockComponent(testInstance);
        Object component = mcm.getInstance(descriptor.getRoleType(), descriptor.getRoleHint());
        ReflectionUtils.setFieldValue((Object)testInstance, (String)field.getName(), (Object)component);
    }

    protected void initializeMockitoComponentManager(Object testInstance, MockitoComponentManager mcm, ExtensionContext context) throws Exception {
        mcm.initializeTest(testInstance, new Object[]{mcm});
    }

    public void afterEach(ExtensionContext extensionContext) throws Exception {
        MockitoComponentManager mcm = this.loadComponentManager(extensionContext);
        if (mcm != null) {
            mcm.dispose();
        }
    }

    public boolean supportsParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        Parameter parameter = parameterContext.getParameter();
        return ComponentManager.class.isAssignableFrom(parameter.getType());
    }

    public Object resolveParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        return this.loadComponentManager(extensionContext);
    }

    private ComponentDescriptor<?> getDescriptor(Class<?> role, List<ComponentDescriptor> descriptors, Field field) throws Exception {
        if (role.equals(InjectMockComponents.class)) {
            if (descriptors.size() > 1) {
                throw new Exception(String.format("The component under field [%s] is implementing several roles. Please disambiguate by using the \"role\" parameter of the @%s annotation.", field.getName(), InjectMockComponents.class.getSimpleName()));
            }
            return descriptors.get(0);
        }
        for (ComponentDescriptor descriptor : descriptors) {
            Class roleClass = ReflectionUtils.getTypeClass((Type)descriptor.getRoleType());
            if (!roleClass.equals(role)) continue;
            return descriptor;
        }
        throw new Exception(String.format("The role type specified in the @%s annotation for field [%s] isn't implemented by the component.", field.getName(), InjectMockComponents.class.getSimpleName()));
    }

    protected MockitoComponentManager loadComponentManager(ExtensionContext context) {
        ExtensionContext.Store store = MockitoComponentManagerExtension.getStore(context);
        Class testClass = context.getRequiredTestClass();
        return (MockitoComponentManager)((Object)store.get((Object)testClass, MockitoComponentManager.class));
    }

    private void removeComponentManager(ExtensionContext context) {
        ExtensionContext.Store store = MockitoComponentManagerExtension.getStore(context);
        Class testClass = context.getRequiredTestClass();
        store.remove((Object)testClass);
    }

    private void saveComponentManager(ExtensionContext context, MockitoComponentManager componentManager) {
        ExtensionContext.Store store = MockitoComponentManagerExtension.getStore(context);
        Class testClass = context.getRequiredTestClass();
        store.put((Object)testClass, (Object)componentManager);
    }

    private static ExtensionContext.Store getStore(ExtensionContext context) {
        return context.getRoot().getStore(NAMESPACE);
    }
}

