/*
 * See the NOTICE file distributed with this work for additional
 * information regarding copyright ownership.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.xwiki.tool.extension.internal;

import javax.inject.Named;

import org.xwiki.component.annotation.Component;
import org.xwiki.extension.Extension;
import org.xwiki.extension.InstallException;
import org.xwiki.extension.job.internal.InstallPlanJob;

/**
 * @version $Id: 4e750ed0ef343f48857f636aa59304d79b19ec7f $
 * @since 9.4RC1
 */
@Component
@Named(InstallPlanJob.JOBTYPE)
public class ExtensionMojoInstallPlanJob extends InstallPlanJob
{
    /**
     * {@inheritDoc}
     * <p>
     * Disable extension type related handling since we don't care in this context.
     * 
     * @see org.xwiki.extension.job.internal.AbstractInstallPlanJob#checkTypeInstall(org.xwiki.extension.Extension,
     *      java.lang.String)
     */
    @Override
    protected void checkTypeInstall(Extension extension, String namespace) throws InstallException
    {
        // Always allowed
    }
}
