/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.tool.extension.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Model;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.DefaultProjectBuildingRequest;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuilder;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.project.ProjectBuildingResult;
import org.codehaus.plexus.PlexusContainer;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.embed.EmbeddableComponentManager;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.configuration.ConfigurationSource;
import org.xwiki.context.Execution;
import org.xwiki.context.ExecutionContext;
import org.xwiki.context.ExecutionContextManager;
import org.xwiki.environment.System;
import org.xwiki.extension.Extension;
import org.xwiki.extension.ExtensionId;
import org.xwiki.extension.InstallException;
import org.xwiki.extension.InstalledExtension;
import org.xwiki.extension.LocalExtension;
import org.xwiki.extension.MutableExtension;
import org.xwiki.extension.internal.ExtensionUtils;
import org.xwiki.extension.internal.converter.ExtensionIdConverter;
import org.xwiki.extension.job.InstallRequest;
import org.xwiki.extension.job.plan.ExtensionPlan;
import org.xwiki.extension.job.plan.ExtensionPlanAction;
import org.xwiki.extension.repository.CoreExtensionRepository;
import org.xwiki.extension.repository.ExtensionRepository;
import org.xwiki.extension.repository.ExtensionRepositoryManager;
import org.xwiki.extension.repository.InstalledExtensionRepository;
import org.xwiki.extension.repository.LocalExtensionRepository;
import org.xwiki.extension.repository.LocalExtensionRepositoryException;
import org.xwiki.extension.repository.internal.ExtensionSerializer;
import org.xwiki.extension.repository.internal.local.DefaultLocalExtension;
import org.xwiki.extension.version.Version;
import org.xwiki.extension.version.internal.DefaultVersion;
import org.xwiki.job.Job;
import org.xwiki.job.Request;
import org.xwiki.properties.converter.Converter;
import org.xwiki.tool.extension.ExtensionOverride;
import org.xwiki.tool.extension.internal.ExtensionMojoCoreExtensionRepository;
import org.xwiki.tool.extension.internal.MavenBuildConfigurationSource;
import org.xwiki.tool.extension.internal.MavenBuildExtensionRepository;
import org.xwiki.tool.extension.util.ExtensionArtifact;

@Component(roles={ExtensionMojoHelper.class})
@Singleton
public class ExtensionMojoHelper
implements AutoCloseable {
    private MavenProject project;
    @Inject
    private ComponentManager componentManager;
    @Inject
    private ExtensionSerializer extensionSerializer;
    @Inject
    private CoreExtensionRepository coreExtensionReposirory;
    @Inject
    private ExtensionRepositoryManager repositories;
    @Inject
    private Converter<Model> converter;
    @Inject
    @Named(value="dependencies")
    private Provider<Job> dependeciesJobProvider;
    @Inject
    @Named(value="install")
    private Provider<Job> installJobProvider;
    @Inject
    private Execution execution;
    @Inject
    private ConfigurationSource configurationSource;
    private InstalledExtensionRepository installedExtensionRepository;
    private LocalExtensionRepository localExtensionRepository;
    private MavenSession session;
    private ArtifactRepository localRepository;
    private PlexusContainer plexusContainer;
    private ProjectBuilder projectBuilder;
    private List<ExtensionOverride> extensionOverrides;
    private MavenBuildExtensionRepository extensionRepository;
    private File permanentDirectory;

    public static ExtensionMojoHelper create(MavenProject project, File permanentDirectory) throws MojoExecutionException {
        ExtensionMojoHelper extensionMojoHelper;
        if (permanentDirectory == null) {
            permanentDirectory = new File(project.getBuild().getDirectory(), "data/");
        }
        EmbeddableComponentManager embeddableComponentManager = (EmbeddableComponentManager)System.initialize((File)permanentDirectory);
        try {
            MavenBuildConfigurationSource configuration = (MavenBuildConfigurationSource)((Object)embeddableComponentManager.getInstance(ConfigurationSource.class));
            configuration.setProperty("extension.repositories", Collections.singletonList(""));
        }
        catch (ComponentLookupException e) {
            throw new MojoExecutionException("Failed to lookup configuration component", (Exception)((Object)e));
        }
        try {
            ExecutionContextManager ecim = (ExecutionContextManager)embeddableComponentManager.getInstance(ExecutionContextManager.class);
            ecim.initialize(new ExecutionContext());
        }
        catch (Exception e) {
            throw new MojoExecutionException("Failed to initialize Execution Context Manager.", e);
        }
        try {
            extensionMojoHelper = (ExtensionMojoHelper)embeddableComponentManager.getInstance(ExtensionMojoHelper.class);
        }
        catch (ComponentLookupException e) {
            throw new MojoExecutionException("Failed to get ExtensionMojoHelper component", (Exception)((Object)e));
        }
        extensionMojoHelper.project = project;
        extensionMojoHelper.permanentDirectory = permanentDirectory;
        return extensionMojoHelper;
    }

    public void initalize(MavenSession session, ArtifactRepository localRepository, PlexusContainer plexusContainer) throws MojoExecutionException {
        this.session = session;
        this.localRepository = localRepository;
        this.plexusContainer = plexusContainer;
        try {
            this.initializeComponents();
        }
        catch (Exception e) {
            throw new MojoExecutionException("Failed to initialize components", e);
        }
    }

    private void initializeComponents() throws Exception {
        this.projectBuilder = (ProjectBuilder)this.plexusContainer.lookup(ProjectBuilder.class);
        this.extensionRepository = new MavenBuildExtensionRepository(this.session, this.localRepository, this.plexusContainer, this.componentManager);
        this.repositories.addRepository((ExtensionRepository)this.extensionRepository);
    }

    public void setExtensionOverrides(List<ExtensionOverride> extensionOverrides) {
        this.extensionOverrides = extensionOverrides;
    }

    private void disposeComponents() {
        System.dispose((ComponentManager)this.componentManager);
    }

    public ComponentManager getComponentManager() {
        return this.componentManager;
    }

    @Override
    public void close() {
        this.execution.removeContext();
        this.disposeComponents();
    }

    public File getPermanentDirectory() {
        return this.permanentDirectory;
    }

    public LocalExtensionRepository getLocalExtensionRepository() throws MojoExecutionException {
        if (this.localExtensionRepository == null) {
            try {
                this.localExtensionRepository = (LocalExtensionRepository)this.componentManager.getInstance(LocalExtensionRepository.class);
            }
            catch (ComponentLookupException e) {
                throw new MojoExecutionException("Failed to get LocalExtensionRepository component", (Exception)((Object)e));
            }
        }
        return this.localExtensionRepository;
    }

    public InstalledExtensionRepository getInstalledExtensionRepository() throws MojoExecutionException {
        if (this.installedExtensionRepository == null) {
            try {
                this.installedExtensionRepository = (InstalledExtensionRepository)this.componentManager.getInstance(InstalledExtensionRepository.class);
            }
            catch (ComponentLookupException e) {
                throw new MojoExecutionException("Failed to get InstalledExtensionRepository component", (Exception)((Object)e));
            }
        }
        return this.installedExtensionRepository;
    }

    public ExtensionMojoCoreExtensionRepository getExtensionMojoCoreExtensionRepository() {
        return (ExtensionMojoCoreExtensionRepository)this.coreExtensionReposirory;
    }

    public MavenProject getMavenProject(Artifact artifact) throws MojoExecutionException {
        try {
            ProjectBuildingRequest request = new DefaultProjectBuildingRequest(this.session.getProjectBuildingRequest()).setProcessPlugins(false).setLocalRepository(this.localRepository).setValidationLevel(0).setRemoteRepositories(this.session.getCurrentProject().getRemoteArtifactRepositories());
            ProjectBuildingResult result = this.projectBuilder.build(artifact, request);
            return result.getProject();
        }
        catch (ProjectBuildingException e) {
            throw new MojoExecutionException(String.format("Failed to build project for [%s]", artifact), (Exception)((Object)e));
        }
    }

    public Extension getExtension(Artifact artifact) throws MojoExecutionException {
        MavenProject project = this.getMavenProject(artifact);
        return this.getExtension(project);
    }

    public Extension getExtension(MavenProject project) {
        Extension mavenExtension = this.toExtension(project.getModel());
        DefaultLocalExtension extension = new DefaultLocalExtension(null, mavenExtension);
        extension.setFile(project.getArtifact().getFile());
        return extension;
    }

    public Extension toExtension(Model model) {
        Extension extension = (Extension)this.converter.convert(Extension.class, (Object)model);
        if (!(extension instanceof MutableExtension)) {
            extension = new DefaultLocalExtension(null, extension);
        }
        this.override((MutableExtension)extension);
        return extension;
    }

    public LocalExtension storeExtension(Artifact artifact) throws MojoExecutionException {
        Extension extension = this.getExtension(artifact);
        return this.storeExtension(extension);
    }

    public LocalExtension storeExtension(Extension extension) throws MojoExecutionException {
        try {
            return this.getLocalExtensionRepository().storeExtension(extension);
        }
        catch (LocalExtensionRepositoryException e) {
            throw new MojoExecutionException("Failed to stored extension", (Exception)((Object)e));
        }
    }

    public void storeExtensionDependencies() throws MojoExecutionException {
        ExtensionPlan plan = this.resolveDependencies(this.project);
        for (ExtensionPlanAction action : plan.getActions()) {
            if (action.getAction() == ExtensionPlanAction.Action.INSTALL) {
                this.storeExtension(action.getExtension());
                continue;
            }
            if (action.getAction() == ExtensionPlanAction.Action.NONE) continue;
            throw new MojoExecutionException("Unexpected action [" + action + "] when storing dependencies of project [" + this.project + "]");
        }
    }

    public ExtensionPlan resolveDependencies(MavenProject project) throws MojoExecutionException {
        InstallRequest installRequest = new InstallRequest();
        for (Dependency dependency : project.getDependencies()) {
            installRequest.addExtension(new ExtensionId(dependency.getGroupId() + ':' + dependency.getArtifactId(), dependency.getVersion()));
        }
        installRequest.setVerbose(false);
        Job installPlanJob = (Job)this.dependeciesJobProvider.get();
        installPlanJob.initialize((Request)installRequest);
        installPlanJob.run();
        ExtensionPlan status = (ExtensionPlan)installPlanJob.getStatus();
        if (status.getError() != null) {
            throw new MojoExecutionException("Failed to resolve dependencies for project [" + project + "] dependencies", status.getError());
        }
        return status;
    }

    public InstalledExtension registerInstalledExtension(Artifact artifact, String namespace, boolean dependency, Map<String, Object> properties) throws MojoExecutionException {
        LocalExtension localExtension = this.storeExtension(artifact);
        try {
            return this.getInstalledExtensionRepository().installExtension(localExtension, namespace, dependency, properties);
        }
        catch (InstallException e) {
            throw new MojoExecutionException("Failed to install extension", (Exception)((Object)e));
        }
    }

    public Job install(Collection<ExtensionArtifact> artifacts, String namespace, Map<String, Object> properties) throws MojoExecutionException {
        InstallRequest installRequest = new InstallRequest();
        return this.install(artifacts, installRequest, namespace, properties);
    }

    public Job install(Collection<ExtensionArtifact> artifacts, InstallRequest installRequest, String namespace, Map<String, Object> properties) throws MojoExecutionException {
        for (ExtensionArtifact artifact : artifacts) {
            installRequest.addExtension(new ExtensionId(artifact.getGroupId() + ':' + artifact.getArtifactId(), artifact.getVersion()));
        }
        return this.install(installRequest, namespace, properties);
    }

    public Job install(Artifact artifact, String namespace, Map<String, Object> properties) throws MojoExecutionException {
        InstallRequest installRequest = new InstallRequest();
        installRequest.addExtension(new ExtensionId(artifact.getGroupId() + ':' + artifact.getArtifactId(), artifact.getVersion()));
        return this.install(installRequest, namespace, properties);
    }

    public Job install(InstallRequest installRequest, String namespace, Map<String, Object> properties) throws MojoExecutionException {
        installRequest.addNamespace(namespace);
        if (properties != null) {
            installRequest.addExtensionProperties(properties);
        }
        installRequest.setVerbose(false);
        Job installJob = (Job)this.installJobProvider.get();
        installJob.initialize((Request)installRequest);
        installJob.run();
        if (installJob.getStatus().getError() != null) {
            throw new MojoExecutionException("Failed to install extension(s)", installJob.getStatus().getError());
        }
        return installJob;
    }

    public void serializeExtension(File path, Artifact artifact) throws MojoExecutionException, IOException, ParserConfigurationException, TransformerException {
        MavenProject mavenProject = this.getMavenProject(artifact);
        this.serializeExtension(path, mavenProject.getModel());
    }

    public void serializeExtension(File path, Model model) throws IOException, ParserConfigurationException, TransformerException {
        Extension mavenExtension = this.toExtension(model);
        if (!path.exists()) {
            try (FileOutputStream stream = new FileOutputStream(path);){
                this.extensionSerializer.saveExtensionDescriptor(mavenExtension, (OutputStream)stream);
            }
        }
    }

    public void override(MutableExtension extension) {
        if (this.extensionOverrides != null) {
            for (ExtensionOverride extensionOverride : this.extensionOverrides) {
                String featuresString;
                String version;
                String id = (String)extensionOverride.get("id");
                if (!extension.getId().getId().equals(id) || (version = (String)extensionOverride.get("version")) != null && !extension.getId().getVersion().equals(new DefaultVersion(id)) || (featuresString = (String)extensionOverride.get("features")) == null) continue;
                List features = ExtensionUtils.importPropertyStringList((String)featuresString, (boolean)true);
                extension.setExtensionFeatures((Collection)ExtensionIdConverter.toExtensionIdList((Collection)features, (Version)extension.getId().getVersion()));
            }
        }
    }

    public void serializeExtension(Artifact artifact, File directory) throws MojoExecutionException {
        File path = new File(directory, artifact.getArtifactId() + '-' + artifact.getBaseVersion() + ".xed");
        try {
            this.serializeExtension(path, artifact);
        }
        catch (Exception e) {
            throw new MojoExecutionException("Failed to write descriptor for artifact [" + artifact + "]", e);
        }
    }

    public void serializeExtensions(Collection<Artifact> artifacts, File directory, String type) throws MojoExecutionException {
        for (Artifact artifact : artifacts) {
            if (artifact.isOptional() || type != null && !type.equals(artifact.getType())) continue;
            this.serializeExtension(artifact, directory);
        }
    }

    public MavenBuildConfigurationSource getMavenBuildConfigurationSource() {
        return (MavenBuildConfigurationSource)this.configurationSource;
    }
}

