/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.script.internal.safe;

import java.lang.reflect.Constructor;
import java.util.Iterator;
import org.xwiki.script.internal.safe.AbstractSafeObject;
import org.xwiki.script.internal.safe.ScriptSafeProvider;

public class SafeIterator<E, I extends Iterator<E>>
extends AbstractSafeObject<I>
implements Iterator<E> {
    private Constructor<? extends E> safeConstructor;

    public SafeIterator(I it, ScriptSafeProvider<?> safeProvider, Constructor<? extends E> safeConstructor) {
        super(it, safeProvider);
        this.safeConstructor = safeConstructor;
    }

    protected E safeElement(E element) {
        if (this.safeConstructor != null) {
            try {
                return this.safeConstructor.newInstance(element, this.safeProvider);
            }
            catch (Exception e) {
                return (E)this.safe(element);
            }
        }
        return (E)this.safe(element);
    }

    @Override
    public boolean hasNext() {
        return ((Iterator)this.getWrapped()).hasNext();
    }

    @Override
    public E next() {
        return this.safeElement(((Iterator)this.getWrapped()).next());
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Operation forbidden in script proxy");
    }
}

