/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.netflux.internal;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.websocket.DecodeException;
import jakarta.websocket.Decoder;
import jakarta.websocket.EncodeException;
import jakarta.websocket.Encoder;
import jakarta.websocket.EndpointConfig;
import java.util.List;

public class JsonConverter
implements Decoder.Text<List<Object>>,
Encoder.Text<List<Object>> {
    private final ObjectMapper mapper = new ObjectMapper();

    public void init(EndpointConfig config) {
    }

    public void destroy() {
    }

    public List<Object> decode(String json) throws DecodeException {
        try {
            return (List)this.mapper.readValue(json, (JavaType)this.mapper.getTypeFactory().constructCollectionType(List.class, Object.class));
        }
        catch (JsonProcessingException e) {
            throw new DecodeException(json, "Failed to parse JSON message.", (Throwable)e);
        }
    }

    public boolean willDecode(String json) {
        return true;
    }

    public String encode(List<Object> list) throws EncodeException {
        try {
            return this.mapper.writeValueAsString(list);
        }
        catch (JsonProcessingException e) {
            throw new EncodeException(list, "Failed to serialize JSON message.", (Throwable)e);
        }
    }
}

