/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.netflux.internal;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.websocket.CloseReason;
import javax.websocket.Endpoint;
import javax.websocket.EndpointConfig;
import javax.websocket.MessageHandler;
import javax.websocket.Session;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.netflux.internal.Bot;
import org.xwiki.netflux.internal.Channel;
import org.xwiki.netflux.internal.ChannelStore;
import org.xwiki.netflux.internal.IdGenerator;
import org.xwiki.netflux.internal.MessageDispatcher;
import org.xwiki.netflux.internal.SendJob;
import org.xwiki.netflux.internal.User;
import org.xwiki.websocket.AbstractPartialStringMessageHandler;
import org.xwiki.websocket.EndpointComponent;

@Component
@Singleton
@Named(value="netflux")
public class NetfluxEndpoint
extends Endpoint
implements EndpointComponent {
    private static final long TIMEOUT_MILLISECONDS = 65000L;
    private static final String NETFLUX_USER = "netflux.user";
    private static final String COMMAND_LEAVE = "LEAVE";
    private static final String COMMAND_JOIN = "JOIN";
    private static final String ERROR_INVALID = "EINVAL";
    private static final String ERROR_NO_ENTITY = "ENOENT";
    private final Object bigLock = new Object();
    private final Map<String, User> users = new HashMap<String, User>();
    @Inject
    private Logger logger;
    @Inject
    private IdGenerator idGenerator;
    @Inject
    private ChannelStore channels;
    @Inject
    private MessageDispatcher dispatcher;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onOpen(final Session session, EndpointConfig config) {
        Object object = this.bigLock;
        synchronized (object) {
            session.setMaxIdleTimeout(65000L);
            User user = this.getOrRegisterUser(session);
            String identMessage = this.dispatcher.buildDefault("", "IDENT", user.getName(), null);
            if (!this.sendMessage(user, identMessage)) {
                return;
            }
            session.addMessageHandler((MessageHandler)new AbstractPartialStringMessageHandler(){

                public void onMessage(String message) {
                    NetfluxEndpoint.this.handleMessage(session, message);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onClose(Session session, CloseReason closeReason) {
        Object object = this.bigLock;
        synchronized (object) {
            this.wsDisconnect(session, closeReason);
        }
    }

    public void onError(Session session, Throwable e) {
        this.logger.debug("Session closed with error.", e);
        this.onClose(session, new CloseReason((CloseReason.CloseCode)CloseReason.CloseCodes.CLOSED_ABNORMALLY, ExceptionUtils.getRootCauseMessage((Throwable)e)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleMessage(Session session, String message) {
        SendJob sendJob;
        Iterator<String> iterator = this.bigLock;
        synchronized (iterator) {
            this.onMessage(session, message);
            sendJob = this.getSendJob();
        }
        while (sendJob != null) {
            for (String msg : sendJob.getMessages()) {
                if (!sendJob.getUser().isConnected()) break;
                if (this.sendMessage(sendJob.getUser(), msg)) continue;
                return;
            }
            sendJob = this.getSendJob();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void wsDisconnect(Session session, CloseReason closeReason) {
        Object object = this.bigLock;
        synchronized (object) {
            User user = this.getOrRegisterUser(session);
            this.logger.debug("Last message from [{}] received [{}ms] ago. Session idle timeout is [{}].", new Object[]{user.getName(), System.currentTimeMillis() - user.getTimeOfLastMessage(), session.getMaxIdleTimeout()});
            this.logger.debug("Disconnect [{}] because [{}] ([{}])", new Object[]{user.getName(), closeReason.getReasonPhrase(), closeReason.getCloseCode()});
            this.users.remove(user.getName());
            user.setConnected(false);
            new LinkedList<Channel>(user.getChannels()).forEach(channel -> this.leaveChannel(user, (Channel)channel, "Quit: [ wsDisconnect() ]"));
        }
    }

    private User getOrRegisterUser(Session session) {
        User user = (User)session.getUserProperties().get(NETFLUX_USER);
        if (user == null) {
            String userId = this.idGenerator.generateUserId();
            user = new User(session, userId);
            this.users.put(userId, user);
            session.getUserProperties().put(NETFLUX_USER, user);
            this.logger.debug("Registered [{}]", (Object)userId);
        }
        return user;
    }

    private void onMessage(Session session, String message) {
        List<Object> msg = this.dispatcher.decode(message);
        if (msg == null) {
            return;
        }
        User user = this.getOrRegisterUser(session);
        user.setTimeOfLastMessage(System.currentTimeMillis());
        Integer seq = (Integer)msg.get(0);
        String cmd = msg.get(1).toString();
        String obj = "";
        if (msg.size() >= 3) {
            obj = Objects.toString(msg.get(2), null);
        }
        if (COMMAND_JOIN.equals(cmd)) {
            this.onCommandJoin(user, seq, obj);
        } else if (COMMAND_LEAVE.equals(cmd)) {
            this.onCommandLeave(user, seq, obj);
        } else if (cmd.equals("PING")) {
            this.onCommandPing(user, seq);
        } else if ("MSG".equals(cmd)) {
            this.onCommandMessage(user, seq, obj, msg);
        }
    }

    private void onCommandJoin(User user, Integer seq, String channelKey) {
        Channel channel;
        if (!StringUtils.isEmpty((CharSequence)channelKey) && channelKey.length() != 32 && channelKey.length() != 48) {
            String errorMsg = this.dispatcher.buildError(seq, ERROR_INVALID, "");
            this.dispatcher.addMessage(user, errorMsg);
            return;
        }
        Channel channel2 = channel = channelKey == null ? null : this.channels.get(channelKey);
        if (channel == null && StringUtils.isEmpty((CharSequence)channelKey)) {
            channel = this.channels.create();
        } else if (channel == null) {
            String errorMsg = this.dispatcher.buildError(seq, ERROR_NO_ENTITY, "");
            this.dispatcher.addMessage(user, errorMsg);
            return;
        }
        String jackMsg = this.dispatcher.buildJoinAck(seq, channel.getKey());
        this.dispatcher.addMessage(user, jackMsg);
        user.getChannels().add(channel);
        LinkedHashSet<String> botsAndUsers = new LinkedHashSet<String>(channel.getBots().keySet());
        botsAndUsers.addAll(channel.getUsers().keySet());
        for (String userOrBotId : botsAndUsers) {
            String inChannelMsg = this.dispatcher.buildDefault(userOrBotId, COMMAND_JOIN, channel.getKey(), null);
            this.dispatcher.addMessage(user, inChannelMsg);
        }
        channel.getUsers().put(user.getName(), user);
        this.channels.prune();
        String joinMsg = this.dispatcher.buildDefault(user.getName(), COMMAND_JOIN, channel.getKey(), null);
        this.sendChannelMessage(COMMAND_JOIN, user, channel, joinMsg);
    }

    private void onCommandLeave(User user, Integer seq, String channelKey) {
        String errorMsg = null;
        if (StringUtils.isEmpty((CharSequence)channelKey)) {
            errorMsg = this.dispatcher.buildError(seq, ERROR_INVALID, "undefined");
        }
        if (errorMsg != null && this.channels.get(channelKey) == null) {
            errorMsg = this.dispatcher.buildError(seq, ERROR_NO_ENTITY, channelKey);
        }
        if (errorMsg != null && !this.channels.get(channelKey).getUsers().containsKey(user.getName())) {
            errorMsg = this.dispatcher.buildError(seq, "NOT_IN_CHAN", channelKey);
        }
        if (errorMsg != null) {
            this.dispatcher.addMessage(user, errorMsg);
            return;
        }
        String ackMsg = this.dispatcher.buildAck(seq);
        this.dispatcher.addMessage(user, ackMsg);
        Channel channel = this.channels.get(channelKey);
        this.leaveChannel(user, channel, "");
    }

    private void leaveChannel(User user, Channel channel, String reason) {
        channel.getUsers().remove(user.getName());
        user.getChannels().remove(channel);
        String leaveMessage = this.dispatcher.buildDefault(user.getName(), COMMAND_LEAVE, channel.getKey(), reason);
        this.sendChannelMessage(COMMAND_LEAVE, user, channel, leaveMessage);
        if (channel.getConnectedUsers().isEmpty()) {
            this.channels.remove(channel);
        }
    }

    private void onCommandPing(User user, Integer seq) {
        String ackMsg = this.dispatcher.buildAck(seq);
        this.dispatcher.addMessage(user, ackMsg);
    }

    private void onCommandMessage(User user, Integer seq, String channelKeyOrUserName, List<Object> msg) {
        String ackMsg = this.dispatcher.buildAck(seq);
        this.dispatcher.addMessage(user, ackMsg);
        Optional<Bot> bot = this.getBot(user, channelKeyOrUserName);
        if (bot.isPresent()) {
            bot.get().onUserMessage(user, msg);
        } else if (this.channels.get(channelKeyOrUserName) != null) {
            String msgMsg = this.dispatcher.buildMessage(0, user.getName(), channelKeyOrUserName, msg.get(3));
            Channel chan = this.channels.get(channelKeyOrUserName);
            this.sendChannelMessage("MSG", user, chan, msgMsg);
        } else if (this.users.containsKey(channelKeyOrUserName)) {
            String msgMsg = this.dispatcher.buildMessage(0, user.getName(), channelKeyOrUserName, msg.get(3));
            this.dispatcher.addMessage(this.users.get(channelKeyOrUserName), msgMsg);
        } else if (!channelKeyOrUserName.isEmpty()) {
            String errorMsg = this.dispatcher.buildError(seq, ERROR_NO_ENTITY, channelKeyOrUserName);
            this.dispatcher.addMessage(user, errorMsg);
        }
    }

    private Optional<Bot> getBot(User user, String id) {
        return user.getChannels().stream().map(channel -> channel.getBots().get(id)).filter(Objects::nonNull).findFirst();
    }

    private boolean sendMessage(User user, String message) {
        try {
            this.logger.debug("Sending to [{}] : [{}]", (Object)user.getName(), (Object)message);
            user.getSession().getBasicRemote().sendText(message);
            return true;
        }
        catch (IOException e) {
            this.logger.debug("Sending failed.", (Throwable)e);
            this.wsDisconnect(user.getSession(), new CloseReason((CloseReason.CloseCode)CloseReason.CloseCodes.CLOSED_ABNORMALLY, ExceptionUtils.getRootCauseMessage((Throwable)e)));
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SendJob getSendJob() {
        Object object = this.bigLock;
        synchronized (object) {
            for (User user : this.users.values()) {
                if (!user.isConnected() || user.getMessagesToBeSent().isEmpty()) continue;
                SendJob out = new SendJob(user, new ArrayList<String>(user.getMessagesToBeSent()));
                user.getMessagesToBeSent().clear();
                return out;
            }
            return null;
        }
    }

    private void sendChannelMessage(String cmd, User me, Channel channel, String message) {
        channel.getBots().values().forEach(bot -> bot.onChannelMessage(channel, me, cmd, message));
        channel.getUsers().values().stream().filter(user -> !"MSG".equals(cmd) || !user.equals(me)).forEach(user -> this.dispatcher.addMessage((User)user, message));
    }
}

