/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.logging.logback.internal;

import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.classic.spi.IThrowableProxy;
import ch.qos.logback.classic.spi.ThrowableProxy;
import ch.qos.logback.core.filter.Filter;
import ch.qos.logback.core.spi.FilterReply;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Marker;
import org.xwiki.logging.Logger;

public class ForbiddenThreadsFilter
extends Filter<ILoggingEvent> {
    private Set<Thread> threads = Collections.newSetFromMap(new ConcurrentHashMap());

    private ThrowableProxy getThrowableProxy(IThrowableProxy proxy) {
        ThrowableProxy throwableProxy;
        return proxy instanceof ThrowableProxy ? (throwableProxy = (ThrowableProxy)proxy) : null;
    }

    private boolean canFilter(ILoggingEvent event) {
        List markers = event.getMarkerList();
        if (markers != null) {
            for (Marker marker : markers) {
                if (marker != Logger.ROOT_MARKER) continue;
                return false;
            }
        }
        ThrowableProxy throwable = this.getThrowableProxy(event.getThrowableProxy());
        while (throwable != null) {
            if (throwable.getThrowable() instanceof VirtualMachineError) {
                return false;
            }
            throwable = this.getThrowableProxy(throwable.getCause());
        }
        return true;
    }

    public FilterReply decide(ILoggingEvent event) {
        if (this.canFilter(event) && this.threads.contains(Thread.currentThread())) {
            return FilterReply.DENY;
        }
        return FilterReply.NEUTRAL;
    }

    public void addThread(Thread thread) {
        this.threads.add(thread);
    }

    public void removeThread(Thread thread) {
        this.threads.remove(thread);
    }
}

