/*
 * See the NOTICE file distributed with this work for additional
 * information regarding copyright ownership.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.xwiki.logging.internal.tail;

import org.slf4j.Logger;
import org.xwiki.logging.event.LogEvent;
import org.xwiki.logging.internal.AbstractLogger;
import org.xwiki.logging.tail.LoggerTail;

/**
 * Base class to help implement {@link LoggerTail}.
 * 
 * @version $Id: fee95b76d7a14519c659f60cded6f06a3ac23787 $
 * @since 11.9RC1
 */
public abstract class AbstractLoggerTail extends AbstractLogger implements LoggerTail
{
    @Override
    public void log(Logger logger)
    {
        for (LogEvent logEvent : this) {
            if (logEvent != null) {
                logEvent.log(logger);
            }
        }
    }
}
