/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.logging;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.slf4j.Marker;
import org.xwiki.logging.Logger;
import org.xwiki.logging.event.LogEvent;

public class CompositeLogger
implements Logger {
    private List<Logger> loggers;

    public CompositeLogger(Collection<Logger> loggers) {
        this.loggers = new ArrayList<Logger>(loggers);
    }

    public CompositeLogger(Logger ... loggers) {
        this.loggers = new ArrayList<Logger>(loggers.length);
        for (Logger logger : loggers) {
            this.loggers.add(logger);
        }
    }

    public String getName() {
        return null;
    }

    public boolean isTraceEnabled() {
        for (Logger logger : this.loggers) {
            if (!logger.isTraceEnabled()) continue;
            return true;
        }
        return false;
    }

    public void trace(String msg) {
        for (Logger logger : this.loggers) {
            logger.trace(msg);
        }
    }

    public void trace(String format, Object arg) {
        for (Logger logger : this.loggers) {
            logger.trace(format, arg);
        }
    }

    public void trace(String format, Object arg1, Object arg2) {
        for (Logger logger : this.loggers) {
            logger.trace(format, arg1, arg2);
        }
    }

    public void trace(String format, Object ... arguments) {
        for (Logger logger : this.loggers) {
            logger.trace(format, arguments);
        }
    }

    public void trace(String msg, Throwable t) {
        for (Logger logger : this.loggers) {
            logger.trace(msg, t);
        }
    }

    public boolean isTraceEnabled(Marker marker) {
        for (Logger logger : this.loggers) {
            if (!logger.isTraceEnabled(marker)) continue;
            return true;
        }
        return false;
    }

    public void trace(Marker marker, String msg) {
        for (Logger logger : this.loggers) {
            logger.trace(marker, msg);
        }
    }

    public void trace(Marker marker, String format, Object arg) {
        for (Logger logger : this.loggers) {
            logger.trace(marker, format, arg);
        }
    }

    public void trace(Marker marker, String format, Object arg1, Object arg2) {
        for (Logger logger : this.loggers) {
            logger.trace(marker, format, arg1, arg2);
        }
    }

    public void trace(Marker marker, String format, Object ... arguments) {
        for (Logger logger : this.loggers) {
            logger.trace(marker, format, arguments);
        }
    }

    public void trace(Marker marker, String msg, Throwable t) {
        for (Logger logger : this.loggers) {
            logger.trace(marker, msg, t);
        }
    }

    public boolean isDebugEnabled() {
        for (Logger logger : this.loggers) {
            if (!logger.isDebugEnabled()) continue;
            return true;
        }
        return false;
    }

    public void debug(String msg) {
        for (Logger logger : this.loggers) {
            logger.debug(msg);
        }
    }

    public void debug(String format, Object arg) {
        for (Logger logger : this.loggers) {
            logger.debug(format, arg);
        }
    }

    public void debug(String format, Object arg1, Object arg2) {
        for (Logger logger : this.loggers) {
            logger.debug(format, arg1, arg2);
        }
    }

    public void debug(String format, Object ... arguments) {
        for (Logger logger : this.loggers) {
            logger.debug(format, arguments);
        }
    }

    public void debug(String msg, Throwable t) {
        for (Logger logger : this.loggers) {
            logger.debug(msg, t);
        }
    }

    public boolean isDebugEnabled(Marker marker) {
        for (Logger logger : this.loggers) {
            if (!logger.isDebugEnabled(marker)) continue;
            return true;
        }
        return false;
    }

    public void debug(Marker marker, String msg) {
        for (Logger logger : this.loggers) {
            logger.debug(marker, msg);
        }
    }

    public void debug(Marker marker, String format, Object arg) {
        for (Logger logger : this.loggers) {
            logger.debug(marker, format, arg);
        }
    }

    public void debug(Marker marker, String format, Object arg1, Object arg2) {
        for (Logger logger : this.loggers) {
            logger.debug(marker, format, arg1, arg2);
        }
    }

    public void debug(Marker marker, String format, Object ... arguments) {
        for (Logger logger : this.loggers) {
            logger.debug(marker, format, arguments);
        }
    }

    public void debug(Marker marker, String msg, Throwable t) {
        for (Logger logger : this.loggers) {
            logger.debug(marker, msg, t);
        }
    }

    public boolean isInfoEnabled() {
        for (Logger logger : this.loggers) {
            if (!logger.isInfoEnabled()) continue;
            return true;
        }
        return false;
    }

    public void info(String msg) {
        for (Logger logger : this.loggers) {
            logger.info(msg);
        }
    }

    public void info(String format, Object arg) {
        for (Logger logger : this.loggers) {
            logger.info(format, arg);
        }
    }

    public void info(String format, Object arg1, Object arg2) {
        for (Logger logger : this.loggers) {
            logger.info(format, arg1, arg2);
        }
    }

    public void info(String format, Object ... arguments) {
        for (Logger logger : this.loggers) {
            logger.info(format, arguments);
        }
    }

    public void info(String msg, Throwable t) {
        for (Logger logger : this.loggers) {
            logger.info(msg, t);
        }
    }

    public boolean isInfoEnabled(Marker marker) {
        for (Logger logger : this.loggers) {
            if (!logger.isInfoEnabled(marker)) continue;
            return true;
        }
        return false;
    }

    public void info(Marker marker, String msg) {
        for (Logger logger : this.loggers) {
            logger.info(marker, msg);
        }
    }

    public void info(Marker marker, String format, Object arg) {
        for (Logger logger : this.loggers) {
            logger.info(marker, format, arg);
        }
    }

    public void info(Marker marker, String format, Object arg1, Object arg2) {
        for (Logger logger : this.loggers) {
            logger.info(marker, format, arg1, arg2);
        }
    }

    public void info(Marker marker, String format, Object ... arguments) {
        for (Logger logger : this.loggers) {
            logger.info(marker, format, arguments);
        }
    }

    public void info(Marker marker, String msg, Throwable t) {
        for (Logger logger : this.loggers) {
            logger.info(marker, msg, t);
        }
    }

    public boolean isWarnEnabled() {
        for (Logger logger : this.loggers) {
            if (!logger.isWarnEnabled()) continue;
            return true;
        }
        return false;
    }

    public void warn(String msg) {
        for (Logger logger : this.loggers) {
            logger.warn(msg);
        }
    }

    public void warn(String format, Object arg) {
        for (Logger logger : this.loggers) {
            logger.warn(format, arg);
        }
    }

    public void warn(String format, Object arg1, Object arg2) {
        for (Logger logger : this.loggers) {
            logger.warn(format, arg1, arg2);
        }
    }

    public void warn(String format, Object ... arguments) {
        for (Logger logger : this.loggers) {
            logger.warn(format, arguments);
        }
    }

    public void warn(String msg, Throwable t) {
        for (Logger logger : this.loggers) {
            logger.warn(msg, t);
        }
    }

    public boolean isWarnEnabled(Marker marker) {
        for (Logger logger : this.loggers) {
            if (!logger.isWarnEnabled(marker)) continue;
            return true;
        }
        return false;
    }

    public void warn(Marker marker, String msg) {
        for (Logger logger : this.loggers) {
            logger.warn(marker, msg);
        }
    }

    public void warn(Marker marker, String format, Object arg) {
        for (Logger logger : this.loggers) {
            logger.warn(marker, format, arg);
        }
    }

    public void warn(Marker marker, String format, Object arg1, Object arg2) {
        for (Logger logger : this.loggers) {
            logger.warn(marker, format, arg1, arg2);
        }
    }

    public void warn(Marker marker, String format, Object ... arguments) {
        for (Logger logger : this.loggers) {
            logger.warn(marker, format, arguments);
        }
    }

    public void warn(Marker marker, String msg, Throwable t) {
        for (Logger logger : this.loggers) {
            logger.warn(marker, msg, t);
        }
    }

    public boolean isErrorEnabled() {
        for (Logger logger : this.loggers) {
            if (!logger.isErrorEnabled()) continue;
            return true;
        }
        return false;
    }

    public void error(String msg) {
        for (Logger logger : this.loggers) {
            logger.error(msg);
        }
    }

    public void error(String format, Object arg) {
        for (Logger logger : this.loggers) {
            logger.error(format, arg);
        }
    }

    public void error(String format, Object arg1, Object arg2) {
        for (Logger logger : this.loggers) {
            logger.error(format, arg1, arg2);
        }
    }

    public void error(String format, Object ... arguments) {
        for (Logger logger : this.loggers) {
            logger.error(format, arguments);
        }
    }

    public void error(String msg, Throwable t) {
        for (Logger logger : this.loggers) {
            logger.error(msg, t);
        }
    }

    public boolean isErrorEnabled(Marker marker) {
        for (Logger logger : this.loggers) {
            if (!logger.isErrorEnabled(marker)) continue;
            return true;
        }
        return false;
    }

    public void error(Marker marker, String msg) {
        for (Logger logger : this.loggers) {
            logger.error(marker, msg);
        }
    }

    public void error(Marker marker, String format, Object arg) {
        for (Logger logger : this.loggers) {
            logger.error(marker, format, arg);
        }
    }

    public void error(Marker marker, String format, Object arg1, Object arg2) {
        for (Logger logger : this.loggers) {
            logger.error(marker, format, arg1, arg2);
        }
    }

    public void error(Marker marker, String format, Object ... arguments) {
        for (Logger logger : this.loggers) {
            logger.error(marker, format, arguments);
        }
    }

    public void error(Marker marker, String msg, Throwable t) {
        for (Logger logger : this.loggers) {
            logger.error(marker, msg, t);
        }
    }

    @Override
    public void log(LogEvent logEvent) {
        for (Logger logger : this.loggers) {
            logger.log(logEvent);
        }
    }
}

