/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.logging.internal.helpers;

import org.xwiki.logging.internal.helpers.AbstractMessageParser;

public class SLF4JMessageParser
extends AbstractMessageParser {
    public static final String ARGUMENT_STR = "{}";
    private static final char ESCAPE_CHAR = '\\';
    private int currentMessageIndex;

    public SLF4JMessageParser(String buffer) {
        this(buffer.toCharArray());
    }

    public SLF4JMessageParser(char[] buffer) {
        super(buffer, '\\');
    }

    @Override
    protected boolean shouldStopEscaping(boolean escaped, int current) {
        return escaped && this.buffer[current + 1] != '\\';
    }

    @Override
    protected boolean isEscaped(int current) {
        char nextChar;
        return current < this.buffer.length && ((nextChar = this.buffer[current + 1]) == '\\' || nextChar == '{');
    }

    @Override
    protected AbstractMessageParser.MessageIndex extractIndex(int current) {
        int i = current;
        if (this.buffer[current] != '{') {
            return null;
        }
        if (++i == this.buffer.length || this.buffer[i] != '}') {
            return null;
        }
        return new AbstractMessageParser.MessageIndex(ARGUMENT_STR, this.currentMessageIndex++);
    }

    protected int countEscaping(int current) {
        int nb = 1;
        for (int i = current + 1; i < this.buffer.length && this.buffer[i] == this.escapeChar; ++i) {
            ++nb;
        }
        return nb;
    }

    protected int isMessageIndex(int current) {
        int i = current;
        if (this.buffer[current] != '{') {
            return current;
        }
        if (++i == this.buffer.length) {
            return current;
        }
        return this.buffer[i] == '}' ? i + 1 : current;
    }
}

