/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.logging.internal.helpers;

public abstract class AbstractMessageParser {
    static final char ARGUMENT_START = '{';
    static final char ARGUMENT_STOP = '}';
    protected final char[] buffer;
    protected int bufferIndex;
    protected final char escapeChar;
    protected MessageElement currentMessageElement;

    protected AbstractMessageParser(char[] buffer, char escapeChar) {
        this.buffer = buffer;
        this.escapeChar = escapeChar;
    }

    public MessageElement getCurrentMessageElement() {
        return this.currentMessageElement;
    }

    public MessageElement next() {
        int i;
        StringBuilder str = new StringBuilder(this.buffer.length - this.bufferIndex);
        boolean escaped = false;
        for (i = this.bufferIndex; i < this.buffer.length; ++i) {
            char c = this.buffer[i];
            if (!escaped) {
                if (c == this.escapeChar) {
                    if (this.isEscaped(i)) {
                        escaped = true;
                        continue;
                    }
                } else if (c == '{') {
                    if (!str.isEmpty()) break;
                    MessageIndex index = this.handleMessageIndex(i);
                    if (index != null) {
                        return index;
                    }
                }
            }
            str.append(c);
            if (!this.shouldStopEscaping(escaped, i)) continue;
            escaped = false;
        }
        if (!str.isEmpty()) {
            return this.handleMessageString(str, i);
        }
        return null;
    }

    protected MessageIndex handleMessageIndex(int current) {
        MessageIndex index = this.extractIndex(current);
        if (index != null) {
            this.bufferIndex = current + index.getString().length();
            this.currentMessageElement = index;
            return index;
        }
        return null;
    }

    protected abstract MessageIndex extractIndex(int var1);

    protected MessageElement handleMessageString(StringBuilder str, int current) {
        this.bufferIndex = current;
        this.currentMessageElement = new MessageString(str.toString());
        return this.currentMessageElement;
    }

    protected abstract boolean isEscaped(int var1);

    protected abstract boolean shouldStopEscaping(boolean var1, int var2);

    public static class MessageElement {
        private String string;

        protected MessageElement(String string) {
            this.string = string;
        }

        public String getString() {
            return this.string;
        }

        public String toString() {
            return this.getString();
        }
    }

    public static class MessageIndex
    extends MessageElement {
        private int index;

        public MessageIndex(String string, int index) {
            super(string);
            this.index = index;
        }

        public int getIndex() {
            return this.index;
        }

        @Override
        public String toString() {
            return this.getIndex() + 58 + this.getString();
        }
    }

    public static class MessageString
    extends MessageElement {
        public MessageString(String string) {
            super(string);
        }
    }
}

