/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.logging.internal.helpers;

public class MessageParser {
    public static final String ARGUMENT_STR = "{}";
    static final char ARGUMENT_START = '{';
    static final char ARGUMENT_STOP = '}';
    private static final char ESCAPE_CHAR = '\\';
    private char[] buffer;
    private boolean translations;
    private int bufferIndex;
    private int currentMessageIndex;
    private boolean previousWasDoubleEscaped;
    private MessageElement currentMessageElement;

    public MessageParser(String buffer, boolean translations) {
        this(buffer.toCharArray(), translations);
    }

    public MessageParser(char[] buffer, boolean translations) {
        this.buffer = buffer;
        this.translations = translations;
    }

    public MessageElement getCurrentMessageElement() {
        return this.currentMessageElement;
    }

    public MessageElement next() {
        int i;
        StringBuilder str = new StringBuilder();
        for (i = this.bufferIndex; i < this.buffer.length; ++i) {
            int iNext;
            if (this.buffer[i] == '\\') {
                int nb = this.countEscaping(i);
                int iNext2 = i + nb;
                if (iNext2 == this.buffer.length) {
                    i = iNext2;
                    break;
                }
                if (this.isMessageIndex(iNext2) > iNext2) {
                    str.append(this.buffer, this.bufferIndex, iNext2 - 1 - this.bufferIndex);
                    this.bufferIndex = i = iNext2;
                    if (nb <= 1) continue;
                    this.previousWasDoubleEscaped = true;
                    this.currentMessageElement = new MessageString(str.toString());
                    return this.currentMessageElement;
                }
                i = iNext2;
                continue;
            }
            if (this.buffer[i] != '{' || (iNext = this.isMessageIndex(i)) == i) continue;
            if (this.bufferIndex == i) {
                String messageIndexString = String.valueOf(this.buffer, i, iNext - i);
                int messageIndex = this.translations && messageIndexString.length() > 2 ? Integer.parseInt(messageIndexString.substring(1, messageIndexString.length() - 1)) : this.currentMessageIndex;
                ++this.currentMessageIndex;
                this.currentMessageElement = this.previousWasDoubleEscaped ? new MessageIndex("\\" + messageIndexString, messageIndex) : new MessageIndex(messageIndexString, messageIndex);
                this.bufferIndex = iNext;
                return this.currentMessageElement;
            }
            this.currentMessageElement = new MessageString(String.valueOf(this.buffer, this.bufferIndex, i - this.bufferIndex));
            this.bufferIndex = i;
            return this.currentMessageElement;
        }
        if (i == this.bufferIndex) {
            return null;
        }
        this.currentMessageElement = new MessageString(String.valueOf(this.buffer, this.bufferIndex, i - this.bufferIndex));
        this.bufferIndex = i;
        return this.currentMessageElement;
    }

    private int countEscaping(int current) {
        int nb = 1;
        for (int i = current + 1; i < this.buffer.length && this.buffer[i] == '\\'; ++i) {
            ++nb;
        }
        return nb;
    }

    private int isMessageIndex(int current) {
        int i = current;
        if (this.buffer[current] != '{') {
            return current;
        }
        if (++i == this.buffer.length) {
            return current;
        }
        if (this.translations) {
            while (this.buffer[i] != '}') {
                if (i == this.buffer.length) {
                    return current;
                }
                if (this.buffer[i] < '0' || this.buffer[i] > '9') {
                    return current;
                }
                ++i;
            }
        }
        return this.buffer[i] == '}' ? i + 1 : current;
    }

    public static class MessageElement {
        private String string;

        protected MessageElement(String string) {
            this.string = string;
        }

        public String getString() {
            return this.string;
        }
    }

    public static class MessageString
    extends MessageElement {
        public MessageString(String string) {
            super(string);
        }
    }

    public static class MessageIndex
    extends MessageElement {
        private int index;

        public MessageIndex(String string, int index) {
            super(string);
            this.index = index;
        }

        public int getIndex() {
            return this.index;
        }
    }
}

