/*
 * See the NOTICE file distributed with this work for additional
 * information regarding copyright ownership.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.xwiki.logging.tail;

import java.io.IOException;

import org.xwiki.logging.Logger;

/**
 * Extends {@link Logger} and provide tail-like APIs to navigate in it.
 * 
 * @version $Id: b97b621181d7496bbb55d8005f81d27b9992c336 $
 * @since 11.9RC1
 */
public interface LoggerTail extends Logger, LogTail, AutoCloseable
{
    /**
     * Force writing and wait for any writing to be finished.
     * @throws IOException when failing to flush
     */
    void flush() throws IOException;
}
