/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.logging;

import java.util.Arrays;
import org.slf4j.Marker;
import org.xwiki.logging.LogLevel;
import org.xwiki.logging.Message;
import org.xwiki.logging.event.BeginLogEvent;
import org.xwiki.logging.event.EndLogEvent;
import org.xwiki.logging.event.LogEvent;
import org.xwiki.logging.internal.helpers.MessageParser;
import org.xwiki.stability.Unstable;

public final class LogUtils {
    private LogUtils() {
    }

    public static LogEvent newLogEvent(Marker marker, LogLevel level, String message, Object[] argumentArray, Throwable throwable) {
        return LogUtils.newLogEvent(marker, level, message, argumentArray, throwable, System.currentTimeMillis());
    }

    public static LogEvent newLogEvent(Marker marker, LogLevel level, String message, Object[] argumentArray, Throwable throwable, long timeStamp) {
        if (marker != null) {
            if (marker.contains(LogEvent.MARKER_BEGIN)) {
                return new BeginLogEvent(marker, level, message, argumentArray, throwable, timeStamp);
            }
            if (marker.contains(LogEvent.MARKER_END)) {
                return new EndLogEvent(marker, level, message, argumentArray, throwable, timeStamp);
            }
        }
        return new LogEvent(marker, level, message, argumentArray, throwable, timeStamp);
    }

    @Unstable
    public static LogEvent newLogEvent(Marker marker, LogLevel level, String message, Object[] arguments) {
        Throwable throwable;
        Object[] actualArray;
        if (arguments.length > 0 && arguments[arguments.length - 1] instanceof Throwable) {
            actualArray = Arrays.copyOf(arguments, arguments.length - 1);
            throwable = (Throwable)arguments[arguments.length - 1];
        } else {
            actualArray = arguments;
            throwable = null;
        }
        return LogUtils.newLogEvent(marker, level, message, actualArray, throwable);
    }

    public static LogEvent translate(LogEvent logEvent, String translatedMessage) {
        return (LogEvent)LogUtils.translate((Message)logEvent, translatedMessage);
    }

    @Unstable
    public static Message translate(Message message, String translatedPattern) {
        if (translatedPattern != null) {
            MessageParser parser = new MessageParser(translatedPattern, true);
            Object[] defaultArguments = message.getArgumentArray();
            Object[] arguments = new Object[defaultArguments.length];
            StringBuilder translatedMessage = new StringBuilder();
            int index = 0;
            MessageParser.MessageElement element = parser.next();
            while (element != null) {
                if (element instanceof MessageParser.MessageIndex) {
                    translatedMessage.append("{}");
                    arguments[index++] = defaultArguments[((MessageParser.MessageIndex)element).getIndex()];
                } else {
                    translatedMessage.append(element.getString());
                }
                element = parser.next();
            }
            while (index < arguments.length) {
                arguments[index] = defaultArguments[index];
                ++index;
            }
            if (message instanceof LogEvent) {
                LogEvent logEvent = (LogEvent)message;
                return new LogEvent(logEvent.getMarker(), logEvent.getLevel(), translatedMessage.toString(), arguments, logEvent.getThrowable(), logEvent.getTimeStamp());
            }
            return new Message(message.getMarker(), translatedMessage.toString(), arguments, message.getThrowable());
        }
        return message;
    }

    @Unstable
    public static Object[] getArgumentArray(Object ... arguments) {
        if (arguments.length > 0 && arguments[arguments.length - 1] instanceof Throwable) {
            return Arrays.copyOf(arguments, arguments.length - 1);
        }
        return arguments;
    }

    @Unstable
    public static Throwable getThrowable(Object ... arguments) {
        if (arguments.length > 0 && arguments[arguments.length - 1] instanceof Throwable) {
            return (Throwable)arguments[arguments.length - 1];
        }
        return null;
    }
}

