/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.logging;

import java.io.Serializable;
import java.util.List;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.slf4j.Marker;
import org.slf4j.helpers.MessageFormatter;
import org.xwiki.logging.internal.helpers.ExtendedMessageFormatter;
import org.xwiki.logging.marker.ContainerMarker;
import org.xwiki.logging.marker.TranslationMarker;

public class Message
implements Serializable,
CharSequence {
    private static final long serialVersionUID = 1L;
    private Marker marker;
    private String message;
    private Object[] argumentArray;
    private Throwable throwable;
    private transient String formattedMessage;

    protected Message() {
    }

    public Message(String message) {
        this(new TranslationMarker(message), message, null, null);
    }

    public Message(Message message) {
        this(message.getMarker(), message.getMessage(), message.getArgumentArray(), message.getThrowable());
    }

    public Message(String message, Object[] argumentArray, Throwable throwable) {
        this(null, message, argumentArray, throwable);
    }

    public Message(String translationKey, String message, Object ... arguments) {
        this(new TranslationMarker(translationKey), message, arguments, null);
    }

    public Message(Marker marker, String message, Object[] argumentArray, Throwable throwable) {
        this.marker = marker;
        this.message = message;
        this.argumentArray = argumentArray;
        this.throwable = throwable;
    }

    public Marker getMarker() {
        return this.marker;
    }

    public String getMessage() {
        return this.message;
    }

    public Object[] getArgumentArray() {
        return this.argumentArray;
    }

    public Throwable getThrowable() {
        return this.throwable;
    }

    public String getFormattedMessage() {
        if (this.formattedMessage != null) {
            return this.formattedMessage;
        }
        this.formattedMessage = this.argumentArray != null ? MessageFormatter.arrayFormat((String)this.message, (Object[])this.argumentArray).getMessage() : this.message;
        return this.formattedMessage;
    }

    public List<String> getMessageElements() {
        return ExtendedMessageFormatter.parseMessage(this.getMessage(), this.getArgumentArray());
    }

    public String getTranslationKey() {
        ContainerMarker containerMarker;
        TranslationMarker translationMarker;
        if (this.getMarker() instanceof ContainerMarker && (translationMarker = (TranslationMarker)(containerMarker = (ContainerMarker)this.getMarker()).get("xwiki.translation")) != null) {
            return ((TranslationMarker)this.getMarker()).getTranslationKey();
        }
        return null;
    }

    @Override
    public String toString() {
        return this.getFormattedMessage();
    }

    public int hashCode() {
        return new HashCodeBuilder(7, 11).append((Object)this.getMarker()).append((Object)this.getMessage()).append(this.getArgumentArray()).append((Object)this.getThrowable()).toHashCode();
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (object.getClass() != this.getClass()) {
            if (object instanceof String) {
                return this.equals((String)object);
            }
            return false;
        }
        Message rhs = (Message)object;
        return new EqualsBuilder().append((Object)this.getMarker(), (Object)rhs.getMarker()).append((Object)this.getMessage(), (Object)rhs.getMessage()).append(this.getArgumentArray(), rhs.getArgumentArray()).append((Object)this.getThrowable(), (Object)rhs.getThrowable()).isEquals();
    }

    public boolean equals(String formatedMessage) {
        return this.getFormattedMessage().equals(formatedMessage);
    }

    @Override
    public int length() {
        return this.getFormattedMessage().length();
    }

    @Override
    public char charAt(int index) {
        return this.getFormattedMessage().charAt(index);
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        return this.getFormattedMessage().subSequence(start, end);
    }
}

