/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.component.annotation;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Provider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.annotation.ComponentDeclaration;
import org.xwiki.component.annotation.ComponentDescriptorFactory;
import org.xwiki.component.annotation.ComponentRole;
import org.xwiki.component.annotation.Role;
import org.xwiki.component.descriptor.ComponentDescriptor;
import org.xwiki.component.descriptor.DefaultComponentDescriptor;
import org.xwiki.component.internal.RoleHint;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.component.util.DefaultParameterizedType;
import org.xwiki.component.util.ReflectionUtils;

public class ComponentAnnotationLoader {
    public static final String COMPONENT_LIST = "META-INF/components.txt";
    @Deprecated
    public static final String COMPONENT_OVERRIDE_LIST = "META-INF/component-overrides.txt";
    private static final String COMPONENT_LIST_ENCODING = "UTF-8";
    private ComponentDescriptorFactory factory = new ComponentDescriptorFactory();
    private static final Logger LOGGER = LoggerFactory.getLogger(ComponentAnnotationLoader.class);

    public void initialize(ComponentManager manager, ClassLoader classLoader) {
        try {
            List<ComponentDeclaration> componentDeclarations = this.getDeclaredComponents(classLoader, COMPONENT_LIST);
            List<ComponentDeclaration> componentOverrideDeclarations = this.getDeclaredComponents(classLoader, COMPONENT_OVERRIDE_LIST);
            for (ComponentDeclaration componentOverrideDeclaration : componentOverrideDeclarations) {
                componentDeclarations.remove(componentOverrideDeclaration);
                componentDeclarations.add(new ComponentDeclaration(componentOverrideDeclaration.getImplementationClassName(), 0));
            }
            this.initialize(manager, classLoader, componentDeclarations);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to get the list of components to load", e);
        }
    }

    public void initialize(ComponentManager manager, ClassLoader classLoader, List<ComponentDeclaration> componentDeclarations) {
        this.register(manager, classLoader, componentDeclarations);
    }

    public void register(ComponentManager manager, ClassLoader classLoader, List<ComponentDeclaration> componentDeclarations) {
        try {
            HashMap descriptorMap = new HashMap();
            HashMap priorityMap = new HashMap();
            for (ComponentDeclaration componentDeclaration : componentDeclarations) {
                Class<?> componentClass = classLoader.loadClass(componentDeclaration.getImplementationClassName());
                for (Type componentRoleType : this.findComponentRoleTypes(componentClass)) {
                    for (ComponentDescriptor componentDescriptor : this.factory.createComponentDescriptors(componentClass, componentRoleType)) {
                        RoleHint roleHint = new RoleHint(componentDescriptor.getRoleType(), componentDescriptor.getRoleHint());
                        this.addComponent(descriptorMap, priorityMap, roleHint, componentDescriptor, componentDeclaration, true);
                    }
                }
            }
            for (ComponentDescriptor descriptor : descriptorMap.values()) {
                manager.registerComponent(descriptor);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to dynamically load components with annotations", e);
        }
    }

    private void addComponent(Map<RoleHint<?>, ComponentDescriptor<?>> descriptorMap, Map<RoleHint<?>, Integer> priorityMap, RoleHint<?> roleHint, ComponentDescriptor<?> componentDescriptor, ComponentDeclaration componentDeclaration, boolean warn) {
        if (descriptorMap.containsKey(roleHint)) {
            int currentPriority = priorityMap.get(roleHint);
            if (componentDeclaration.getPriority() < currentPriority) {
                descriptorMap.put(roleHint, componentDescriptor);
                priorityMap.put(roleHint, componentDeclaration.getPriority());
            } else if (componentDeclaration.getPriority() == currentPriority) {
                if (warn) {
                    this.getLogger().warn("Component [{}] which implements [{}] tried to overwrite component [{}]. However, no action was taken since both components have the same priority level of [{}].", new Object[]{componentDeclaration.getImplementationClassName(), roleHint, descriptorMap.get(roleHint).getImplementation().getName(), currentPriority});
                }
            } else {
                this.getLogger().debug("Ignored component [{}] since its priority level of [{}] is lower than the currently registered component [{}] which has a priority of [{}]", new Object[]{componentDeclaration.getImplementationClassName(), componentDeclaration.getPriority(), currentPriority});
            }
        } else {
            descriptorMap.put(roleHint, componentDescriptor);
            priorityMap.put(roleHint, componentDeclaration.getPriority());
        }
    }

    public void unregister(ComponentManager manager, ClassLoader classLoader, List<ComponentDeclaration> componentDeclarations) {
        for (ComponentDeclaration componentDeclaration : componentDeclarations) {
            try {
                for (ComponentDescriptor componentDescriptor : this.getComponentsDescriptors(classLoader.loadClass(componentDeclaration.getImplementationClassName()))) {
                    manager.unregisterComponent(componentDescriptor);
                    if (!(componentDescriptor.getRoleType() instanceof ParameterizedType)) continue;
                    Class roleClass = ReflectionUtils.getTypeClass((Type)componentDescriptor.getRoleType());
                    DefaultComponentDescriptor classComponentDescriptor = new DefaultComponentDescriptor(componentDescriptor);
                    classComponentDescriptor.setRoleType((Type)roleClass);
                    manager.unregisterComponent((ComponentDescriptor)classComponentDescriptor);
                }
            }
            catch (ClassNotFoundException e) {
                this.getLogger().warn("Can't find any existing component with class [{}]. Ignoring it.", (Object)componentDeclaration.getImplementationClassName());
            }
        }
    }

    public List<ComponentDescriptor> getComponentsDescriptors(Class<?> componentClass) {
        ArrayList<ComponentDescriptor> descriptors = new ArrayList<ComponentDescriptor>();
        for (Type componentRoleType : this.findComponentRoleTypes(componentClass)) {
            descriptors.addAll(this.factory.createComponentDescriptors(componentClass, componentRoleType));
        }
        return descriptors;
    }

    public Set<Type> findComponentRoleTypes(Class<?> componentClass) {
        return this.findComponentRoleTypes(componentClass, null);
    }

    public Set<Type> findComponentRoleTypes(Class<?> componentClass, Type[] parameters) {
        LinkedHashSet<Type> types = new LinkedHashSet<Type>();
        Component component = componentClass.getAnnotation(Component.class);
        if (component != null && component.roles().length > 0) {
            types.addAll(Arrays.asList(component.roles()));
        } else {
            for (Type interfaceType : componentClass.getGenericInterfaces()) {
                Type[] interfaceParameters;
                Class interfaceClass;
                if (interfaceType instanceof ParameterizedType) {
                    ParameterizedType interfaceParameterizedType = (ParameterizedType)interfaceType;
                    interfaceClass = ReflectionUtils.getTypeClass((Type)interfaceType);
                    Type[] variableParameters = interfaceParameterizedType.getActualTypeArguments();
                    interfaceParameters = ReflectionUtils.resolveSuperArguments((Type[])variableParameters, componentClass, (Type[])parameters);
                    if (interfaceParameters == null) {
                        interfaceType = interfaceClass;
                    } else if (interfaceParameters != variableParameters) {
                        interfaceType = new DefaultParameterizedType(interfaceParameterizedType.getOwnerType(), interfaceClass, interfaceParameters);
                    }
                } else {
                    if (!(interfaceType instanceof Class)) continue;
                    interfaceClass = (Class)interfaceType;
                    interfaceParameters = null;
                }
                types.addAll(this.findComponentRoleTypes(interfaceClass, interfaceParameters));
                if (ReflectionUtils.getDirectAnnotation(Role.class, (AnnotatedElement)interfaceClass) != null) {
                    types.add(interfaceType);
                }
                if (Provider.class.isAssignableFrom(interfaceClass)) {
                    types.add(interfaceType);
                }
                if (ReflectionUtils.getDirectAnnotation(ComponentRole.class, (AnnotatedElement)interfaceClass) == null) continue;
                types.add(interfaceClass);
            }
            Type superType = componentClass.getGenericSuperclass();
            if (superType != null && superType != Object.class) {
                if (superType instanceof ParameterizedType) {
                    ParameterizedType superParameterizedType = (ParameterizedType)superType;
                    types.addAll(this.findComponentRoleTypes((Class)superParameterizedType.getRawType(), ReflectionUtils.resolveSuperArguments((Type[])superParameterizedType.getActualTypeArguments(), componentClass, (Type[])parameters)));
                } else if (superType instanceof Class) {
                    types.addAll(this.findComponentRoleTypes((Class)superType, null));
                }
            }
        }
        return types;
    }

    @Deprecated
    public Set<Class<?>> findComponentRoleClasses(Class<?> componentClass) {
        LinkedHashSet classes = new LinkedHashSet();
        Component component = componentClass.getAnnotation(Component.class);
        if (component != null && component.roles().length > 0) {
            classes.addAll(Arrays.asList(component.roles()));
        } else {
            for (Class<?> interfaceClass : componentClass.getInterfaces()) {
                classes.addAll(this.findComponentRoleClasses(interfaceClass));
                for (Annotation annotation : interfaceClass.getDeclaredAnnotations()) {
                    if (annotation.annotationType() != ComponentRole.class) continue;
                    classes.add(interfaceClass);
                }
                if (!Provider.class.isAssignableFrom(interfaceClass)) continue;
                classes.add(interfaceClass);
            }
            Class<?> superClass = componentClass.getSuperclass();
            if (superClass != null && superClass != Object.class) {
                classes.addAll(this.findComponentRoleClasses(superClass));
            }
        }
        return classes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<ComponentDeclaration> getDeclaredComponents(ClassLoader classLoader, String location) throws IOException {
        ArrayList<ComponentDeclaration> annotatedClassNames = new ArrayList<ComponentDeclaration>();
        Enumeration<URL> urls = classLoader.getResources(location);
        while (urls.hasMoreElements()) {
            URL url = urls.nextElement();
            InputStream componentListStream = url.openStream();
            try {
                annotatedClassNames.addAll(this.getDeclaredComponents(componentListStream));
            }
            finally {
                componentListStream.close();
            }
        }
        return annotatedClassNames;
    }

    public List<ComponentDeclaration> getDeclaredComponents(InputStream componentListStream) throws IOException {
        String inputLine;
        ArrayList<ComponentDeclaration> annotatedClassNames = new ArrayList<ComponentDeclaration>();
        BufferedReader in = new BufferedReader(new InputStreamReader(componentListStream, COMPONENT_LIST_ENCODING));
        while ((inputLine = in.readLine()) != null) {
            if (inputLine.trim().length() <= 0) continue;
            try {
                String[] chunks = inputLine.split(":");
                if (chunks.length > 1) {
                    annotatedClassNames.add(new ComponentDeclaration(chunks[1], Integer.parseInt(chunks[0])));
                    continue;
                }
                annotatedClassNames.add(new ComponentDeclaration(chunks[0]));
            }
            catch (Exception e) {
                this.getLogger().error("Failed to parse component declaration from [{}]", (Object)inputLine, (Object)e);
            }
        }
        return annotatedClassNames;
    }

    protected Logger getLogger() {
        return LOGGER;
    }
}

