/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.component.descriptor;

import java.lang.reflect.Type;
import java.util.Objects;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.xwiki.component.descriptor.ComponentRole;
import org.xwiki.component.util.ReflectionUtils;
import org.xwiki.text.XWikiToStringBuilder;

public class DefaultComponentRole<T>
implements ComponentRole<T> {
    private Type roleType;
    private String roleHint = "default";

    public DefaultComponentRole() {
    }

    public DefaultComponentRole(ComponentRole<T> componentRole) {
        this(componentRole.getRoleType(), componentRole.getRoleHint());
    }

    public DefaultComponentRole(Type roleType, String roleHint) {
        this.setRoleType(roleType);
        this.setRoleHint(roleHint);
    }

    @Override
    public Type getRoleType() {
        return this.roleType;
    }

    public void setRoleType(Type roleType) {
        this.roleType = roleType;
    }

    public void setRoleHint(String roleHint) {
        this.roleHint = roleHint;
    }

    @Override
    public String getRoleHint() {
        return this.roleHint;
    }

    public String toString() {
        XWikiToStringBuilder builder = new XWikiToStringBuilder((Object)this);
        builder.append("role", null == this.getRoleType() ? "<null>" : this.getRoleType());
        builder.append("hint", (Object)this.getRoleHint());
        return builder.toString();
    }

    public boolean equals(Object object) {
        boolean result;
        if (this == object) {
            result = true;
        } else if (object == null || object.getClass() != this.getClass()) {
            result = false;
        } else {
            ComponentRole cr = (ComponentRole)object;
            result = Objects.equals(this.getRoleType(), cr.getRoleType()) && Objects.equals(this.getRoleHint(), cr.getRoleHint());
        }
        return result;
    }

    public int hashCode() {
        HashCodeBuilder builder = new HashCodeBuilder();
        builder.append((Object)this.getRoleType());
        builder.append((Object)this.getRoleHint());
        return builder.toHashCode();
    }

    @Deprecated
    public void setRole(Class<T> role) {
        this.roleType = role;
    }

    @Override
    @Deprecated
    public Class<T> getRole() {
        return ReflectionUtils.getTypeClass(this.getRoleType());
    }
}

