/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.classloader.internal;

import edu.emory.mathcs.util.classloader.ResourceHandle;
import edu.emory.mathcs.util.classloader.ResourceUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.security.Permission;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.xwiki.classloader.internal.JarURLConnection;

@Deprecated
public class ResourceLoader {
    private static final String JAR_INDEX_ENTRY_NAME = "META-INF/INDEX.LIST";
    private URLStreamHandler jarHandler;
    private Map<String, JarInfo> url2jarInfo = new HashMap<String, JarInfo>();

    public ResourceLoader(URLStreamHandler jarHandler) {
        this.jarHandler = jarHandler;
    }

    public ResourceHandle getResource(URL source, String name) {
        return this.getResource(source, name, new HashSet<URL>(), null);
    }

    public ResourceHandle getResource(URL[] sources, String name) {
        HashSet<URL> visited = new HashSet<URL>();
        URL[] uRLArray = sources;
        int n = sources.length;
        int n2 = 0;
        while (n2 < n) {
            URL source = uRLArray[n2];
            ResourceHandle h = this.getResource(source, name, visited, null);
            if (h != null) {
                return h;
            }
            ++n2;
        }
        return null;
    }

    public Enumeration<ResourceHandle> getResources(URL source, String name) {
        return new ResourceEnumeration<ResourceHandle>(new URL[]{source}, name, false);
    }

    public Enumeration<ResourceHandle> getResources(URL[] sources, String name) {
        return new ResourceEnumeration<ResourceHandle>((URL[])sources.clone(), name, false);
    }

    private ResourceHandle getResource(final URL source, String name, Set<URL> visitedJars, Set<URL> skip) {
        name = ResourceUtils.canonizePath((String)name);
        if (ResourceLoader.isDir(source)) {
            URLConnection conn;
            URL url;
            try {
                URI relUri = new URI(null, null, null, -1, name, null, null);
                url = new URL(source, relUri.getRawPath());
            }
            catch (URISyntaxException uRISyntaxException) {
                throw new IllegalArgumentException("Illegal resource name: " + name);
            }
            catch (MalformedURLException malformedURLException) {
                return null;
            }
            if (skip != null && skip.contains(url)) {
                return null;
            }
            try {
                conn = url.openConnection();
                conn.getInputStream();
            }
            catch (IOException iOException) {
                return null;
            }
            final String finalName = name;
            return new ResourceHandle(){

                public String getName() {
                    return finalName;
                }

                public URL getURL() {
                    return url;
                }

                public URL getCodeSourceURL() {
                    return source;
                }

                public InputStream getInputStream() throws IOException {
                    return conn.getInputStream();
                }

                public int getContentLength() {
                    return conn.getContentLength();
                }

                public void close() {
                    try {
                        this.getInputStream().close();
                    }
                    catch (IOException iOException) {}
                }
            };
        }
        try {
            return this.getJarInfo(source).getResource(name, visitedJars, skip);
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    public URL findResource(URL source, String name) {
        return this.findResource(source, name, new HashSet<URL>(), null);
    }

    public URL findResource(URL[] sources, String name) {
        HashSet<URL> visited = new HashSet<URL>();
        URL[] uRLArray = sources;
        int n = sources.length;
        int n2 = 0;
        while (n2 < n) {
            URL source = uRLArray[n2];
            URL url = this.findResource(source, name, visited, null);
            if (url != null) {
                return url;
            }
            ++n2;
        }
        return null;
    }

    public Enumeration<URL> findResources(URL source, String name) {
        return new ResourceEnumeration<URL>(new URL[]{source}, name, true);
    }

    public Enumeration<URL> findResources(URL[] sources, String name) {
        return new ResourceEnumeration<URL>((URL[])sources.clone(), name, true);
    }

    private URL findResource(URL source, String name, Set<URL> visitedJars, Set<URL> skip) {
        name = ResourceUtils.canonizePath((String)name);
        if (ResourceLoader.isDir(source)) {
            URLConnection conn;
            URL url;
            block10: {
                try {
                    url = new URL(source, name);
                }
                catch (MalformedURLException malformedURLException) {
                    return null;
                }
                if (skip != null && skip.contains(url)) {
                    return null;
                }
                try {
                    conn = url.openConnection();
                    if (!(conn instanceof HttpURLConnection)) break block10;
                    HttpURLConnection httpConn = (HttpURLConnection)conn;
                    httpConn.setRequestMethod("HEAD");
                    if (httpConn.getResponseCode() >= 400) {
                        return null;
                    }
                }
                catch (IOException iOException) {
                    return null;
                }
            }
            conn.getInputStream().close();
            return url;
        }
        try {
            ResourceHandle rh = this.getJarInfo(source).getResource(name, visitedJars, skip);
            return rh != null ? rh.getURL() : null;
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    protected static boolean isDir(URL url) {
        String file = url.getFile();
        return file != null && file.endsWith("/");
    }

    private static Map<String, URL[]> package2url(Map<URL, List<String>> indexes) {
        HashMap<String, ArrayList<URL>> prefix2url = new HashMap<String, ArrayList<URL>>();
        for (Map.Entry<URL, List<String>> entry : indexes.entrySet()) {
            URL url = entry.getKey();
            for (String prefix : entry.getValue()) {
                ArrayList<URL> prefixList = (ArrayList<URL>)prefix2url.get(prefix);
                if (prefixList == null) {
                    prefixList = new ArrayList<URL>();
                    prefix2url.put(prefix, prefixList);
                }
                prefixList.add(url);
            }
        }
        HashMap<String, URL[]> result = new HashMap<String, URL[]>(prefix2url.size());
        for (Map.Entry entry : prefix2url.entrySet()) {
            List list = (List)entry.getValue();
            result.put((String)entry.getKey(), list.toArray(new URL[list.size()]));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JarInfo getJarInfo(URL url) throws MalformedURLException {
        JarInfo jinfo;
        Map<String, JarInfo> map = this.url2jarInfo;
        synchronized (map) {
            jinfo = this.url2jarInfo.get(url.toExternalForm());
            if (jinfo == null) {
                jinfo = new JarInfo(this, url);
                this.url2jarInfo.put(url.toExternalForm(), jinfo);
            }
        }
        return jinfo;
    }

    private static Map<URL, List<String>> parseJarIndex(URL cxt, JarFile jar) throws IOException {
        String line;
        JarEntry entry = jar.getJarEntry(JAR_INDEX_ENTRY_NAME);
        if (entry == null) {
            return Collections.emptyMap();
        }
        InputStream is = jar.getInputStream(entry);
        BufferedReader reader = new BufferedReader(new InputStreamReader(is, "UTF-8"));
        LinkedHashMap<URL, List<String>> result = new LinkedHashMap<URL, List<String>>();
        while ((line = reader.readLine()) != null && line.trim().length() > 0) {
        }
        ArrayList<String> currentList = null;
        block1: while ((line = reader.readLine()) != null) {
            URL currentURL = new URL(cxt, line);
            currentList = new ArrayList<String>();
            result.put(currentURL, currentList);
            while (true) {
                if ((line = reader.readLine()) == null || line.trim().length() == 0) continue block1;
                currentList.add(line);
            }
            break;
        }
        return result;
    }

    private static URL[] parseClassPath(JarFile jar, URL source) throws IOException {
        Manifest man = jar.getManifest();
        if (man == null) {
            return new URL[0];
        }
        Attributes attr = man.getMainAttributes();
        if (attr == null) {
            return new URL[0];
        }
        String cp = attr.getValue(Attributes.Name.CLASS_PATH);
        if (cp == null) {
            return new URL[0];
        }
        StringTokenizer tokenizer = new StringTokenizer(cp);
        ArrayList<URL> cpList = new ArrayList<URL>();
        URI sourceURI = URI.create(source.toString());
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            try {
                try {
                    URI uri = new URI(token);
                    if (!uri.isAbsolute()) {
                        uri = sourceURI.resolve(uri);
                    }
                    cpList.add(uri.toURL());
                }
                catch (URISyntaxException uRISyntaxException) {
                    URL url = new URL(source, token);
                    cpList.add(url);
                }
            }
            catch (MalformedURLException e) {
                throw new IOException(e.getMessage());
            }
        }
        return cpList.toArray(new URL[cpList.size()]);
    }

    static /* synthetic */ URL access$5(ResourceLoader resourceLoader, URL uRL, String string, Set set, Set set2) {
        return resourceLoader.findResource(uRL, string, set, set2);
    }

    static /* synthetic */ ResourceHandle access$6(ResourceLoader resourceLoader, URL uRL, String string, Set set, Set set2) {
        return resourceLoader.getResource(uRL, string, set, set2);
    }

    private static class JarInfo {
        private ResourceLoader loader;
        private URL source;
        private URL base;
        private JarFile jar;
        private boolean resolved;
        private Permission perm;
        private URL[] classPath;
        private String[] index;
        private Map<String, URL[]> package2url;

        JarInfo(ResourceLoader loader, URL source) throws MalformedURLException {
            this.loader = loader;
            this.source = source;
            this.base = new URL("jar", "", -1, source + "!/", loader.jarHandler);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        ResourceHandle getResource(String name, Set<URL> visited, Set<URL> skip) {
            URL[] dependencies;
            Object jentry;
            URL url;
            visited.add(this.source);
            try {
                URI relUri = new URI(null, null, null, -1, name, null, null);
                url = new URL(this.base, relUri.getRawPath());
            }
            catch (URISyntaxException uRISyntaxException) {
                throw new IllegalArgumentException("Illegal resource name: " + name);
            }
            catch (MalformedURLException malformedURLException) {
                return null;
            }
            try {
                JarFile jfile = this.getJarFileIfPossiblyContains(name);
                if (!(jfile == null || (jentry = this.jar.getJarEntry(name)) == null || skip != null && skip.contains(url))) {
                    return new JarResourceHandle(jfile, (JarEntry)jentry, url, this.source);
                }
            }
            catch (IOException iOException) {
                return null;
            }
            jentry = this;
            synchronized (jentry) {
                if (this.package2url != null) {
                    int idx = name.lastIndexOf("/");
                    String prefix = idx > 0 ? name.substring(0, idx) : name;
                    dependencies = this.package2url.get(prefix);
                } else {
                    assert (this.classPath != null);
                    dependencies = this.classPath;
                }
            }
            if (dependencies == null) {
                return null;
            }
            URL[] uRLArray = dependencies;
            int n = dependencies.length;
            int n2 = 0;
            while (n2 < n) {
                URL cpUrl = uRLArray[n2];
                if (!visited.contains(cpUrl)) {
                    try {
                        JarInfo depJInfo = this.loader.getJarInfo(cpUrl);
                        ResourceHandle rh = depJInfo.getResource(name, visited, skip);
                        if (rh != null) {
                            return rh;
                        }
                    }
                    catch (MalformedURLException malformedURLException) {}
                }
                ++n2;
            }
            return null;
        }

        synchronized void setIndex(List<String> newIndex) {
            if (this.jar != null) {
                return;
            }
            if (this.index != null) {
                HashSet<String> violating = new HashSet<String>(Arrays.asList(this.index));
                violating.removeAll(newIndex);
                if (!violating.isEmpty()) {
                    throw new RuntimeException("Invalid JAR index: the following entries were previously declared, but they are not present in the new index: " + ((Object)violating).toString());
                }
            }
            this.index = newIndex.toArray(new String[newIndex.size()]);
            Arrays.sort(this.index);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public JarFile getJarFileIfPossiblyContains(String name) throws IOException {
            JarInfo jarInfo;
            Map indexes;
            JarInfo jarInfo2 = this;
            synchronized (jarInfo2) {
                block24: {
                    if (this.jar != null) {
                        SecurityManager security = System.getSecurityManager();
                        if (security != null) {
                            security.checkPermission(this.perm);
                        }
                        try {
                            while (!this.resolved) {
                                this.wait();
                            }
                        }
                        catch (InterruptedException interruptedException) {
                            throw new IOException("Interrupted");
                        }
                        return this.jar;
                    }
                    if (this.index == null) break block24;
                    int pos = name.lastIndexOf(47);
                    if (pos > 0) {
                        name = name.substring(0, pos);
                    }
                    if (Arrays.binarySearch(this.index, name) >= 0) break block24;
                    return null;
                }
                URLConnection connection = this.base.openConnection();
                this.perm = connection.getPermission();
                JarFile jar = connection instanceof JarURLConnection ? ((JarURLConnection)((Object)connection)).getJarFile() : ((java.net.JarURLConnection)connection).getJarFile();
                if (this.index != null) {
                    HashSet<String> indices = new HashSet<String>(Arrays.asList(this.index));
                    Enumeration<JarEntry> entries = jar.entries();
                    while (entries.hasMoreElements()) {
                        JarEntry entry = entries.nextElement();
                        String indexEntry = entry.getName();
                        int pos = indexEntry.lastIndexOf(47);
                        if (pos > 0) {
                            indexEntry = indexEntry.substring(0, pos);
                        }
                        indices.remove(indexEntry);
                    }
                    if (!indices.isEmpty()) {
                        throw new RuntimeException("Invalid JAR index: the following entries not found in JAR: " + indices);
                    }
                }
                this.jar = jar;
                this.classPath = ResourceLoader.parseClassPath(jar, this.source);
                indexes = ResourceLoader.parseJarIndex(this.source, jar);
                indexes.remove(this.source);
                if (!indexes.isEmpty()) {
                    this.package2url = ResourceLoader.package2url(indexes);
                }
            }
            try {
                for (Map.Entry entry : indexes.entrySet()) {
                    URL url = (URL)entry.getKey();
                    if (url.toExternalForm().equals(this.source.toExternalForm())) continue;
                    List index = (List)entry.getValue();
                    this.loader.getJarInfo(url).setIndex(index);
                }
            }
            catch (Throwable throwable) {
                jarInfo = this;
                synchronized (jarInfo) {
                    this.resolved = true;
                    this.notifyAll();
                }
                throw throwable;
            }
            jarInfo = this;
            synchronized (jarInfo) {
                this.resolved = true;
                this.notifyAll();
            }
            return this.jar;
        }
    }

    private static class JarResourceHandle
    extends ResourceHandle {
        final JarFile jar;
        final JarEntry jentry;
        final URL url;
        final URL codeSource;

        JarResourceHandle(JarFile jar, JarEntry jentry, URL url, URL codeSource) {
            this.jar = jar;
            this.jentry = jentry;
            this.url = url;
            this.codeSource = codeSource;
        }

        public String getName() {
            return this.jentry.getName();
        }

        public URL getURL() {
            return this.url;
        }

        public URL getCodeSourceURL() {
            return this.codeSource;
        }

        public InputStream getInputStream() throws IOException {
            return this.jar.getInputStream(this.jentry);
        }

        public int getContentLength() {
            return (int)this.jentry.getSize();
        }

        public Manifest getManifest() throws IOException {
            return this.jar.getManifest();
        }

        public Attributes getAttributes() throws IOException {
            return this.jentry.getAttributes();
        }

        public Certificate[] getCertificates() {
            return this.jentry.getCertificates();
        }

        public void close() {
        }
    }

    private class ResourceEnumeration<T>
    implements Enumeration<T> {
        final URL[] urls;
        final String name;
        final boolean findOnly;
        int idx;
        T next;
        Set<URL> previousURLs = new HashSet<URL>();

        ResourceEnumeration(URL[] urls, String name, boolean findOnly) {
            this.urls = urls;
            this.name = name;
            this.findOnly = findOnly;
            this.idx = 0;
        }

        @Override
        public boolean hasMoreElements() {
            this.fetchNext();
            return this.next != null;
        }

        @Override
        public T nextElement() {
            this.fetchNext();
            if (this.next == null) {
                throw new NoSuchElementException();
            }
            T nextElement = this.next;
            this.next = null;
            return nextElement;
        }

        /*
         * Unable to fully structure code
         */
        private void fetchNext() {
            if (this.next == null) ** GOTO lbl18
            return;
lbl-1000:
            // 1 sources

            {
                if (this.findOnly) {
                    url = ResourceLoader.access$5(ResourceLoader.this, this.urls[this.idx], this.name, new HashSet<E>(), this.previousURLs);
                    if (url != null) {
                        this.previousURLs.add(url);
                        this.next = url;
                        return;
                    }
                } else {
                    h = ResourceLoader.access$6(ResourceLoader.this, this.urls[this.idx], this.name, new HashSet<E>(), this.previousURLs);
                    if (h != null) {
                        this.previousURLs.add(h.getURL());
                        this.next = h;
                        return;
                    }
                }
                ++this.idx;
lbl18:
                // 2 sources

                ** while (this.idx < this.urls.length)
            }
lbl19:
            // 1 sources

        }
    }
}

