/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.http;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.BitSet;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.StringUtils;
import org.apache.commons.codec.net.URLCodec;
import org.xwiki.stability.Unstable;

@Unstable
public final class URIUtils {
    static final BitSet SAFE_PATH_SEGMENT;
    static final BitSet SAFE_PATH;
    private static final URLCodec FORMENCODED_CODEC;

    private URIUtils() {
    }

    public static String encodePath(String decoded) {
        if (decoded == null || decoded.isEmpty()) {
            return decoded;
        }
        return StringUtils.newStringUtf8((byte[])URLCodec.encodeUrl((BitSet)SAFE_PATH, (byte[])decoded.getBytes(StandardCharsets.UTF_8)));
    }

    public static String encodePathSegment(String decoded) {
        return StringUtils.newStringUtf8((byte[])URLCodec.encodeUrl((BitSet)SAFE_PATH_SEGMENT, (byte[])decoded.getBytes(StandardCharsets.UTF_8)));
    }

    public static String decode(String encoded) throws IOException {
        try {
            return FORMENCODED_CODEC.decode(encoded, "utf8");
        }
        catch (DecoderException e) {
            throw new IOException("Failed to decode string [" + encoded + "]", e);
        }
    }

    static {
        int i;
        SAFE_PATH_SEGMENT = new BitSet(256);
        SAFE_PATH = new BitSet(256);
        for (i = 97; i <= 122; ++i) {
            SAFE_PATH_SEGMENT.set(i);
        }
        for (i = 65; i <= 90; ++i) {
            SAFE_PATH_SEGMENT.set(i);
        }
        for (i = 48; i <= 57; ++i) {
            SAFE_PATH_SEGMENT.set(i);
        }
        SAFE_PATH_SEGMENT.set(45);
        SAFE_PATH_SEGMENT.set(46);
        SAFE_PATH_SEGMENT.set(95);
        SAFE_PATH_SEGMENT.set(126);
        SAFE_PATH.set(47);
        SAFE_PATH.or(SAFE_PATH_SEGMENT);
        FORMENCODED_CODEC = new URLCodec();
    }
}

