/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension.repository.internal.core;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.reflections.util.ClasspathHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentLifecycleException;
import org.xwiki.component.phase.Disposable;
import org.xwiki.environment.Environment;
import org.xwiki.extension.Extension;
import org.xwiki.extension.ResolveException;
import org.xwiki.extension.internal.PathUtils;
import org.xwiki.extension.repository.ExtensionRepositoryManager;
import org.xwiki.extension.repository.internal.ExtensionSerializer;
import org.xwiki.extension.repository.internal.core.CoreExtensionCache;
import org.xwiki.extension.repository.internal.core.CoreExtensionScanner;
import org.xwiki.extension.repository.internal.core.DefaultCoreExtension;
import org.xwiki.extension.repository.internal.core.DefaultCoreExtensionRepository;
import org.xwiki.extension.repository.internal.core.ExtensionScanner;
import org.xwiki.extension.version.Version;

@Component
@Singleton
public class DefaultCoreExtensionScanner
implements CoreExtensionScanner,
Disposable {
    private static final Logger SHUTDOWN_LOGGER = LoggerFactory.getLogger((String)"org.xwiki.shutdown");
    @Inject
    private Logger logger;
    @Inject
    private Provider<ExtensionRepositoryManager> repositoryManagerProvider;
    @Inject
    private Environment environment;
    @Inject
    private CoreExtensionCache cache;
    @Inject
    private ExtensionSerializer parser;
    @Inject
    private List<ExtensionScanner> scanners;
    private boolean shouldStop;

    public void dispose() throws ComponentLifecycleException {
        this.shouldStop = true;
    }

    @Override
    public void updateExtensions(Collection<DefaultCoreExtension> extensions) {
        ExtensionRepositoryManager repositoryManager = (ExtensionRepositoryManager)this.repositoryManagerProvider.get();
        for (DefaultCoreExtension extension : extensions) {
            if (this.shouldStop) {
                SHUTDOWN_LOGGER.debug("Aborting Extension Update as XWiki is stopping");
                break;
            }
            if (extension.isComplete()) continue;
            try {
                Extension remoteExtension = repositoryManager.resolve(extension.getId());
                extension.set(remoteExtension);
                extension.setComplete(true);
                if (extension.getDescriptorURL() == null) continue;
                this.cache.store(extension);
            }
            catch (ResolveException e) {
                this.logger.debug("Can't find remote extension with id [{}]", (Object)extension.getId(), (Object)e);
            }
            catch (Exception e) {
                this.logger.warn("Failed to update core extension [{}]: [{}]", new Object[]{extension.getId(), ExceptionUtils.getRootCauseMessage((Throwable)e), e});
            }
        }
    }

    @Override
    public Map<String, DefaultCoreExtension> loadExtensions(DefaultCoreExtensionRepository repository) {
        HashMap<String, DefaultCoreExtension> extensions = new HashMap<String, DefaultCoreExtension>();
        this.loadExtensionsFromClassloaders(extensions, repository);
        return extensions;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public DefaultCoreExtension loadEnvironmentExtension(DefaultCoreExtensionRepository repository) {
        ExtensionScanner scanner;
        DefaultCoreExtension environmentExtension;
        URL xedURL = this.environment.getResource("/META-INF/extension.xed");
        if (xedURL != null) {
            try (InputStream xedStream = this.environment.getResourceAsStream("/META-INF/extension.xed");){
                DefaultCoreExtension throwable3 = this.parser.loadCoreExtensionDescriptor(repository, null, xedStream);
                return throwable3;
            }
            catch (Exception e) {
                this.logger.error("Failed to load [{}] descriptor file", (Object)xedURL, (Object)e);
            }
        }
        Iterator<ExtensionScanner> iterator = this.scanners.iterator();
        do {
            if (iterator.hasNext()) continue;
            this.logger.debug("No declared environmennt extension");
            return null;
        } while ((environmentExtension = (scanner = iterator.next()).scanEnvironment(repository)) == null);
        return environmentExtension;
    }

    private Collection<URL> getJARs() {
        HashSet urls = new HashSet();
        urls.addAll(ClasspathHelper.forPackage((String)"META-INF", (ClassLoader[])new ClassLoader[0]));
        urls.addAll(ClasspathHelper.forResource((String)"META-INF/MANIFEST.MF", (ClassLoader[])new ClassLoader[0]));
        urls.addAll(ClasspathHelper.forPackage((String)"javax", (ClassLoader[])new ClassLoader[0]));
        ArrayList<URL> jarURLs = new ArrayList<URL>(urls.size());
        for (URL url : urls) {
            try {
                jarURLs.add(PathUtils.getExtensionURL(url));
            }
            catch (IOException e) {
                this.logger.error("Failed to convert to extension URL", (Throwable)e);
            }
        }
        return jarURLs;
    }

    private void addCoreExtension(Map<String, DefaultCoreExtension> extensions, DefaultCoreExtension coreExtension) {
        DefaultCoreExtensionScanner.addCoreExtension(extensions, coreExtension, this.logger);
    }

    public static void addCoreExtension(Map<String, DefaultCoreExtension> extensions, DefaultCoreExtension coreExtension, Logger logger) {
        DefaultCoreExtension existingCoreExtension = extensions.get(coreExtension.getId().getId());
        if (existingCoreExtension == null) {
            extensions.put(coreExtension.getId().getId(), coreExtension);
        } else {
            Version existingVersion = existingCoreExtension.getId().getVersion();
            Version version = coreExtension.getId().getVersion();
            int comparizon = version.compareTo(existingVersion);
            if (comparizon != 0) {
                DefaultCoreExtension selectedExtension;
                logger.warn("Collision between core extension [{} ({})] and [{} ({})]", new Object[]{coreExtension.getId(), coreExtension.getDescriptorURL(), existingCoreExtension.getId(), existingCoreExtension.getDescriptorURL()});
                if (comparizon > 0) {
                    extensions.put(coreExtension.getId().getId(), coreExtension);
                    selectedExtension = coreExtension;
                } else {
                    selectedExtension = existingCoreExtension;
                }
                logger.warn("[{} ({})] is selected", (Object)selectedExtension.getId(), (Object)selectedExtension.getDescriptorURL());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DefaultCoreExtension loadCoreExtensionFromXED(URL jarURL, DefaultCoreExtensionRepository repository) {
        String jarString = jarURL.toExternalForm();
        int extIndex = jarString.lastIndexOf(46);
        if (extIndex > 0) {
            InputStream xedStream;
            URL xedURL;
            try {
                xedURL = new URL(jarString.substring(0, extIndex) + ".xed");
            }
            catch (MalformedURLException e) {
                return null;
            }
            try {
                xedStream = xedURL.openStream();
            }
            catch (IOException e) {
                this.logger.debug("Failed to load [{}]", (Object)xedURL, (Object)e);
                return null;
            }
            try {
                DefaultCoreExtension coreExtension = this.parser.loadCoreExtensionDescriptor(repository, jarURL, xedStream);
                coreExtension.setDescriptorURL(xedURL);
                DefaultCoreExtension defaultCoreExtension = coreExtension;
                return defaultCoreExtension;
            }
            catch (Exception e) {
                this.logger.error("Failed to load [{}]", (Object)xedURL, (Object)e);
            }
            finally {
                IOUtils.closeQuietly((InputStream)xedStream);
            }
        }
        return null;
    }

    private void loadExtensionsFromClassloaders(Map<String, DefaultCoreExtension> extensions, DefaultCoreExtensionRepository repository) {
        Collection<URL> jars = this.getJARs();
        this.fromXED(extensions, jars, repository);
        for (ExtensionScanner scanner : this.scanners) {
            scanner.scanJARs(extensions, jars, repository);
        }
        for (ExtensionScanner scanner : this.scanners) {
            scanner.guess(extensions, jars, repository);
        }
    }

    private void fromXED(Map<String, DefaultCoreExtension> extensions, Collection<URL> jars, DefaultCoreExtensionRepository repository) {
        Iterator<URL> it = jars.iterator();
        while (it.hasNext()) {
            URL jarURL = it.next();
            DefaultCoreExtension coreExtension = this.loadCoreExtensionFromXED(jarURL, repository);
            if (coreExtension == null) continue;
            this.addCoreExtension(extensions, coreExtension);
            it.remove();
        }
    }
}

