/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension.job.history;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.xwiki.extension.job.ExtensionRequest;
import org.xwiki.extension.job.history.QuestionRecorder;

public class ExtensionJobHistoryRecord {
    private final String jobType;
    private final ExtensionRequest request;
    private final Map<String, QuestionRecorder<Object>> answers;
    private final Date startDate;
    private final Date endDate;

    public ExtensionJobHistoryRecord(String jobType, ExtensionRequest request, Map<String, QuestionRecorder<Object>> answers, Date startDate, Date endDate) {
        this.jobType = jobType;
        this.request = request;
        this.answers = answers != null ? Collections.unmodifiableMap(answers) : Collections.emptyMap();
        this.startDate = startDate;
        this.endDate = endDate;
    }

    public String getJobType() {
        return this.jobType;
    }

    public ExtensionRequest getRequest() {
        return this.request;
    }

    public Map<String, QuestionRecorder<Object>> getAnswers() {
        return this.answers;
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public Date getEndDate() {
        return this.endDate;
    }

    public String getId() {
        ArrayList<Object> parts = new ArrayList<Object>();
        parts.add(this.endDate.getTime());
        parts.add(this.jobType);
        if (this.request.hasNamespaces()) {
            parts.addAll(this.request.getNamespaces());
        }
        return StringUtils.join(parts, (char)'-');
    }
}

