/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension.version.internal;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xwiki.extension.version.Version;

public class DefaultVersion
implements Version {
    private static final long serialVersionUID = 1L;
    private static final String MAX_INTEGER_STRING = String.valueOf(Integer.MAX_VALUE);
    private static final int MAX_INTEGER_LENGTH = MAX_INTEGER_STRING.length();
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultVersion.class);
    private String rawVersion;
    private List<Element> elements;
    private Version.Type type = Version.Type.STABLE;
    private int hashCode = -1;

    public DefaultVersion(String rawVersion) {
        this.setVersion(rawVersion);
    }

    public DefaultVersion(Version version) {
        this(version.getValue());
    }

    private void initElements() {
        if (this.elements == null) {
            this.parse();
        }
    }

    private void setVersion(String rawVersion) {
        this.rawVersion = rawVersion;
    }

    private void parse() {
        this.elements = new ArrayList<Element>();
        try {
            Tokenizer tokenizer = new Tokenizer(this.rawVersion);
            while (tokenizer.next()) {
                Element element = new Element(tokenizer);
                this.elements.add(element);
                if (element.getVersionType() == Version.Type.STABLE) continue;
                this.type = element.getVersionType();
            }
            DefaultVersion.trimPadding(this.elements);
        }
        catch (Exception e) {
            LOGGER.error("Failed to parse version [" + this.rawVersion + "]", (Throwable)e);
            this.elements.add(new Element(this.rawVersion));
        }
    }

    private static void trimPadding(List<Element> elements) {
        Element element;
        ListIterator<Element> it = elements.listIterator(elements.size());
        while (it.hasPrevious() && (element = it.previous()).compareTo(null) == 0) {
            it.remove();
        }
    }

    @Override
    public Version.Type getType() {
        this.initElements();
        return this.type;
    }

    @Override
    public String getValue() {
        return this.rawVersion;
    }

    public String toString() {
        return this.getValue();
    }

    public int hashCode() {
        if (this.hashCode == -1) {
            this.initElements();
            this.hashCode = this.elements.hashCode();
        }
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        boolean equals = obj instanceof DefaultVersion ? this.equals((DefaultVersion)obj) : (obj instanceof Version ? this.equals(new DefaultVersion(((Version)obj).getValue())) : false);
        return equals;
    }

    public boolean equals(DefaultVersion version) {
        return this.compareTo(version) == 0;
    }

    @Override
    public int compareTo(Version version) {
        if (version == this) {
            return 0;
        }
        if (version instanceof DefaultVersion) {
            return this.compareTo((DefaultVersion)version);
        }
        return this.compareTo(new DefaultVersion(version.getValue()));
    }

    @Override
    public int compareTo(String version) {
        return this.compareTo(new DefaultVersion(version));
    }

    @Override
    public int compareTo(DefaultVersion version) {
        int rel;
        this.initElements();
        version.initElements();
        List<Element> otherElements = version.elements;
        boolean number = true;
        int index = 0;
        while (true) {
            if (index >= this.elements.size() && index >= otherElements.size()) {
                return 0;
            }
            if (index >= this.elements.size()) {
                return -DefaultVersion.comparePadding(otherElements, index, null);
            }
            if (index >= otherElements.size()) {
                return DefaultVersion.comparePadding(this.elements, index, null);
            }
            Element thisElement = this.elements.get(index);
            Element thatElement = otherElements.get(index);
            if (thisElement.isNumber() != thatElement.isNumber()) {
                if (number == thisElement.isNumber()) {
                    rel = DefaultVersion.comparePadding(this.elements, index, number);
                    break;
                }
                rel = -DefaultVersion.comparePadding(otherElements, index, number);
                break;
            }
            rel = thisElement.compareTo(thatElement);
            if (rel != 0) break;
            number = thisElement.isNumber();
            ++index;
        }
        return rel;
    }

    private static int comparePadding(List<Element> elements, int index, Boolean number) {
        int rel = 0;
        ListIterator<Element> it = elements.listIterator(index);
        while (it.hasNext()) {
            Element element = (Element)it.next();
            if ((number == null || number.booleanValue() == element.isNumber()) && (rel = element.compareTo(null)) == 0) continue;
            break;
        }
        return rel;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeObject(this.getValue());
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.setVersion((String)in.readObject());
    }

    static final class Element
    implements Comparable<Element> {
        private static final String ERROR_UNKNOWNKIND = "Unknown version element kind ";
        private static final Map<String, Integer> QUALIFIERS = new HashMap<String, Integer>();
        private final ElementType elementType;
        private final Object value;
        private Version.Type versionType = Version.Type.STABLE;

        private boolean isInteger(String number) {
            return number.length() < MAX_INTEGER_LENGTH || number.length() == MAX_INTEGER_LENGTH && MAX_INTEGER_STRING.compareTo(number) >= 0;
        }

        public Element(String token) {
            this.elementType = ElementType.STRING;
            this.value = token;
        }

        public Element(Tokenizer tokenizer) {
            String token = tokenizer.getToken();
            if (tokenizer.isNumber()) {
                if (this.isInteger(token)) {
                    try {
                        this.elementType = ElementType.INT;
                        this.value = Integer.valueOf(token);
                    }
                    catch (NumberFormatException e) {
                        throw new IllegalStateException(e);
                    }
                } else {
                    this.elementType = ElementType.STRING;
                    this.value = token;
                }
            } else {
                String lowerCaseToken = token.toLowerCase(Locale.ENGLISH);
                Integer qualifier = QUALIFIERS.get(lowerCaseToken);
                if (qualifier != null) {
                    this.elementType = ElementType.QUALIFIER;
                    this.value = qualifier;
                    if (qualifier == -1) {
                        this.versionType = Version.Type.SNAPSHOT;
                    } else if (qualifier < 0) {
                        this.versionType = Version.Type.BETA;
                    }
                } else {
                    this.elementType = ElementType.STRING;
                    this.value = lowerCaseToken;
                }
            }
        }

        public boolean isNumber() {
            return this.elementType == ElementType.INT || this.elementType == ElementType.QUALIFIER;
        }

        public Version.Type getVersionType() {
            return this.versionType;
        }

        @Override
        public int compareTo(Element that) {
            int rel;
            block10: {
                block9: {
                    if (that != null) break block9;
                    switch (this.elementType) {
                        case STRING: {
                            rel = 1;
                            break block10;
                        }
                        case INT: 
                        case QUALIFIER: {
                            rel = (Integer)this.value;
                            break block10;
                        }
                        default: {
                            throw new IllegalStateException(ERROR_UNKNOWNKIND + (Object)((Object)this.elementType));
                        }
                    }
                }
                rel = this.elementType.compareTo(that.elementType);
                if (rel == 0) {
                    switch (this.elementType) {
                        case INT: 
                        case QUALIFIER: {
                            rel = (Integer)this.value - (Integer)that.value;
                            break;
                        }
                        case STRING: {
                            rel = ((String)this.value).compareToIgnoreCase((String)that.value);
                            break;
                        }
                        default: {
                            throw new IllegalStateException(ERROR_UNKNOWNKIND + (Object)((Object)this.elementType));
                        }
                    }
                }
            }
            return rel;
        }

        public boolean equals(Object obj) {
            return obj instanceof Element && this.compareTo((Element)obj) == 0;
        }

        public int hashCode() {
            HashCodeBuilder builder = new HashCodeBuilder();
            builder.append(this.value);
            builder.append((Object)this.elementType);
            return builder.toHashCode();
        }

        public String toString() {
            return this.value.toString();
        }

        static {
            QUALIFIERS.put("alpha", -5);
            QUALIFIERS.put("a", -5);
            QUALIFIERS.put("beta", -4);
            QUALIFIERS.put("b", -4);
            QUALIFIERS.put("milestone", -3);
            QUALIFIERS.put("cr", -2);
            QUALIFIERS.put("rc", -2);
            QUALIFIERS.put("snapshot", -1);
            QUALIFIERS.put("ga", 0);
            QUALIFIERS.put("final", 0);
            QUALIFIERS.put("", 0);
            QUALIFIERS.put("sp", 1);
        }

        static enum ElementType {
            QUALIFIER,
            INT,
            STRING;

        }
    }

    static final class Tokenizer {
        private final String rawVersion;
        private int index;
        private boolean number;
        private String token;

        public Tokenizer(String rawVersion) {
            this.rawVersion = rawVersion.length() > 0 ? rawVersion : "0";
        }

        public String getToken() {
            return this.token;
        }

        public boolean isNumber() {
            return this.number;
        }

        public boolean next() {
            int n = this.rawVersion.length();
            if (this.index >= n) {
                return false;
            }
            int state = -2;
            int start = this.index;
            int end = n;
            while (this.index < n) {
                char c = this.rawVersion.charAt(this.index);
                if (c == '.' || c == '-') {
                    end = this.index++;
                    break;
                }
                int digit = Character.digit(c, 10);
                if (digit >= 0) {
                    if (state == -1) {
                        end = this.index;
                        break;
                    }
                    if (state == 0) {
                        ++start;
                    }
                    state = state > 0 || digit > 0 ? 1 : 0;
                } else {
                    if (state >= 0) {
                        end = this.index;
                        break;
                    }
                    state = -1;
                }
                ++this.index;
            }
            if (start < end) {
                this.token = this.rawVersion.substring(start, end);
                this.number = state >= 0;
            } else {
                this.token = "0";
                this.number = true;
            }
            return true;
        }

        public String toString() {
            return this.token;
        }
    }
}

