/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension.repository.internal.core;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Model;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.reflections.Configuration;
import org.reflections.Reflections;
import org.reflections.scanners.ResourcesScanner;
import org.reflections.scanners.Scanner;
import org.reflections.util.ClasspathHelper;
import org.reflections.util.ConfigurationBuilder;
import org.reflections.util.FilterBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentLifecycleException;
import org.xwiki.component.phase.Disposable;
import org.xwiki.environment.Environment;
import org.xwiki.extension.Extension;
import org.xwiki.extension.ExtensionDependency;
import org.xwiki.extension.ExtensionId;
import org.xwiki.extension.ResolveException;
import org.xwiki.extension.internal.PathUtils;
import org.xwiki.extension.internal.maven.MavenExtension;
import org.xwiki.extension.internal.maven.MavenExtensionDependency;
import org.xwiki.extension.internal.maven.MavenUtils;
import org.xwiki.extension.repository.ExtensionRepositoryManager;
import org.xwiki.extension.repository.internal.ExtensionSerializer;
import org.xwiki.extension.repository.internal.core.CoreExtensionCache;
import org.xwiki.extension.repository.internal.core.CoreExtensionScanner;
import org.xwiki.extension.repository.internal.core.DefaultCoreExtension;
import org.xwiki.extension.repository.internal.core.DefaultCoreExtensionRepository;
import org.xwiki.extension.repository.internal.core.MavenCoreExtension;
import org.xwiki.extension.version.Version;
import org.xwiki.properties.ConverterManager;

@Component
@Singleton
public class DefaultCoreExtensionScanner
implements CoreExtensionScanner,
Disposable {
    private static final Logger SHUTDOWN_LOGGER = LoggerFactory.getLogger((String)"org.xwiki.shutdown");
    @Inject
    private Logger logger;
    @Inject
    private ExtensionRepositoryManager repositoryManager;
    @Inject
    private ConverterManager converter;
    @Inject
    private Environment environment;
    @Inject
    private CoreExtensionCache cache;
    @Inject
    private ExtensionSerializer parser;
    private boolean shouldStop;

    public void dispose() throws ComponentLifecycleException {
        this.shouldStop = true;
    }

    private Dependency toDependency(String id, String version, String type) throws ResolveException {
        Matcher matcher = MavenUtils.PARSER_ID.matcher(id);
        if (!matcher.matches()) {
            throw new ResolveException("Bad id [" + id + "], expected format is <groupId>:<artifactId>[:<classifier>]");
        }
        Dependency dependency = new Dependency();
        dependency.setGroupId(matcher.group(1));
        dependency.setArtifactId(matcher.group(2));
        if (matcher.group(4) != null) {
            dependency.setClassifier(StringUtils.defaultString((String)matcher.group(4), (String)""));
        }
        if (version != null) {
            dependency.setVersion(version);
        }
        if (type != null) {
            dependency.setType(type);
        }
        return dependency;
    }

    private String getArtifactId(DefaultCoreExtension extension) throws ResolveException {
        String artifactId;
        if (extension instanceof MavenExtension) {
            artifactId = ((MavenExtension)((Object)extension)).getMavenArtifactId();
        } else {
            Matcher matcher = MavenUtils.PARSER_ID.matcher(extension.getId().getId());
            if (!matcher.matches()) {
                throw new ResolveException("Bad id " + extension.getId().getId() + ", expected format is <groupId>:<artifactId>[:<classifier>]");
            }
            artifactId = matcher.group(2);
        }
        return artifactId;
    }

    private DefaultCoreExtension getCoreExension(URL jarURL, URL descriptorURL, DefaultCoreExtensionRepository repository) throws Exception {
        DefaultCoreExtension coreExtension = this.cache.getExtension(repository, descriptorURL);
        if (coreExtension != null && coreExtension.getDescriptorURL().equals(descriptorURL)) {
            return coreExtension;
        }
        return this.parseMavenPom(jarURL, descriptorURL, repository);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DefaultCoreExtension parseMavenPom(URL jarURL, URL descriptorURL, DefaultCoreExtensionRepository repository) throws Exception {
        InputStream descriptorStream = descriptorURL.openStream();
        try {
            MavenXpp3Reader reader = new MavenXpp3Reader();
            Model mavenModel = reader.read(descriptorStream);
            MavenUtils.resolveVariables(mavenModel);
            Extension mavenExtension = (Extension)this.converter.convert(Extension.class, (Object)mavenModel);
            MavenCoreExtension coreExtension = new MavenCoreExtension(repository, jarURL, mavenExtension);
            coreExtension.setDescriptorURL(descriptorURL);
            if (mavenModel.getParent() == null) {
                this.cache.store(coreExtension);
                coreExtension.setComplete(true);
            }
            MavenCoreExtension mavenCoreExtension = coreExtension;
            return mavenCoreExtension;
        }
        finally {
            IOUtils.closeQuietly((InputStream)descriptorStream);
        }
    }

    @Override
    public void updateExtensions(Collection<DefaultCoreExtension> extensions) {
        for (DefaultCoreExtension extension : extensions) {
            if (this.shouldStop) {
                SHUTDOWN_LOGGER.debug("Aborting Extension Update as XWiki is stopping");
                break;
            }
            if (extension.isComplete()) continue;
            try {
                Extension remoteExtension = this.repositoryManager.resolve(extension.getId());
                extension.set(remoteExtension);
                extension.setComplete(true);
                if (extension.getDescriptorURL() == null) continue;
                this.cache.store(extension);
            }
            catch (ResolveException e) {
                this.logger.debug("Can't find remote extension with id [{}]", (Object)extension.getId(), (Object)e);
            }
            catch (Exception e) {
                this.logger.warn("Failed to update core extension [{}]: [{}]", new Object[]{extension.getId(), ExceptionUtils.getRootCauseMessage((Throwable)e), e});
            }
        }
    }

    @Override
    public Map<String, DefaultCoreExtension> loadExtensions(DefaultCoreExtensionRepository repository) {
        HashMap<String, DefaultCoreExtension> extensions = new HashMap<String, DefaultCoreExtension>();
        this.loadExtensionsFromClassloaders(extensions, repository);
        return extensions;
    }

    /*
     * Exception decompiling
     */
    @Override
    public DefaultCoreExtension loadEnvironmentExtension(DefaultCoreExtensionRepository repository) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [15[CATCHBLOCK]], but top level block is 8[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private Collection<URL> getJARs() {
        Collection urls = ClasspathHelper.forPackage((String)"META-INF", (ClassLoader[])new ClassLoader[0]);
        ArrayList<URL> jarURLs = new ArrayList<URL>(urls.size());
        for (URL url : urls) {
            try {
                jarURLs.add(PathUtils.getExtensionURL(url, null));
            }
            catch (MalformedURLException e) {
                this.logger.error("Failed to convert to extension URL", (Throwable)e);
            }
        }
        return jarURLs;
    }

    private void addCoreExtension(Map<String, DefaultCoreExtension> extensions, DefaultCoreExtension coreExtension) {
        DefaultCoreExtension existingCoreExtension = extensions.get(coreExtension.getId().getId());
        if (existingCoreExtension == null) {
            extensions.put(coreExtension.getId().getId(), coreExtension);
        } else {
            Version existingVersion = existingCoreExtension.getId().getVersion();
            Version version = coreExtension.getId().getVersion();
            int comparizon = version.compareTo(existingVersion);
            if (comparizon != 0) {
                this.logger.warn("Collision between core extension [{} ({})] and [{} ({})]", new Object[]{coreExtension.getId(), coreExtension.getDescriptorURL(), existingCoreExtension.getId(), existingCoreExtension.getDescriptorURL()});
                if (comparizon > 0) {
                    extensions.put(coreExtension.getId().getId(), coreExtension);
                    this.logger.warn("[{} ({})] is selected", (Object)coreExtension.getId(), (Object)coreExtension.getDescriptorURL());
                } else {
                    this.logger.warn("[{} ({})] is selected", (Object)existingCoreExtension.getId(), (Object)existingCoreExtension.getDescriptorURL());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DefaultCoreExtension loadCoreExtensionFromXED(URL jarURL, DefaultCoreExtensionRepository repository) {
        String jarString = jarURL.toExternalForm();
        int extIndex = jarString.lastIndexOf(46);
        if (extIndex > 0) {
            InputStream xedStream;
            URL xedURL;
            try {
                xedURL = new URL(jarString.substring(0, extIndex) + ".xed");
            }
            catch (MalformedURLException e) {
                return null;
            }
            try {
                xedStream = xedURL.openStream();
            }
            catch (IOException e) {
                this.logger.debug("Failed to load [{}]", (Object)xedURL, (Object)e);
                return null;
            }
            try {
                DefaultCoreExtension coreExtension = this.parser.loadCoreExtensionDescriptor(repository, jarURL, xedStream);
                coreExtension.setDescriptorURL(xedURL);
                DefaultCoreExtension defaultCoreExtension = coreExtension;
                return defaultCoreExtension;
            }
            catch (Exception e) {
                this.logger.error("Failed to load [{}]", (Object)xedURL, (Object)e);
            }
            finally {
                IOUtils.closeQuietly((InputStream)xedStream);
            }
        }
        return null;
    }

    private void loadExtensionsFromClassloaders(Map<String, DefaultCoreExtension> extensions, DefaultCoreExtensionRepository repository) {
        Collection<URL> jars = this.getJARs();
        this.fromXED(extensions, jars, repository);
        this.fromMaven(extensions, jars, repository);
        this.guess(extensions, repository, jars);
    }

    private void fromXED(Map<String, DefaultCoreExtension> extensions, Collection<URL> jars, DefaultCoreExtensionRepository repository) {
        Iterator<URL> it = jars.iterator();
        while (it.hasNext()) {
            URL jarURL = it.next();
            DefaultCoreExtension coreExtension = this.loadCoreExtensionFromXED(jarURL, repository);
            if (coreExtension == null) continue;
            this.addCoreExtension(extensions, coreExtension);
            it.remove();
        }
    }

    private void fromMaven(Map<String, DefaultCoreExtension> extensions, Collection<URL> jars, DefaultCoreExtensionRepository repository) {
        Iterator<URL> it = jars.iterator();
        while (it.hasNext()) {
            URL jar = it.next();
            if (!this.fromMaven(extensions, jar, repository)) continue;
            it.remove();
        }
    }

    private boolean fromMaven(Map<String, DefaultCoreExtension> extensions, URL jarURL, DefaultCoreExtensionRepository repository) {
        ConfigurationBuilder configurationBuilder = new ConfigurationBuilder();
        configurationBuilder.setScanners(new Scanner[]{new ResourcesScanner()});
        configurationBuilder.setUrls(new URL[]{jarURL});
        configurationBuilder.filterInputsBy((Predicate)new FilterBuilder.Include(FilterBuilder.prefix((String)"META-INF.maven")));
        Reflections reflections = new Reflections((Configuration)configurationBuilder);
        Set descriptors = reflections.getResources(Predicates.equalTo((Object)"pom.xml"));
        boolean found = false;
        for (String descriptor : descriptors) {
            URL descriptorURL;
            try {
                descriptorURL = new URL("jar:" + jarURL.toExternalForm() + "!/" + descriptor);
            }
            catch (MalformedURLException e1) {
                this.logger.error("Failed to access resource [{}] from jar [{}]", (Object)descriptor, (Object)jarURL);
                continue;
            }
            try {
                DefaultCoreExtension coreExtension = this.getCoreExension(jarURL, descriptorURL, repository);
                this.addCoreExtension(extensions, coreExtension);
                found = true;
            }
            catch (Exception e) {
                this.logger.warn("Failed to parse extension descriptor [{}] ([{}])", new Object[]{descriptorURL, descriptor, e});
            }
        }
        return found;
    }

    private void guess(Map<String, DefaultCoreExtension> extensions, DefaultCoreExtensionRepository repository, Collection<URL> jars) {
        HashSet<ExtensionDependency> dependencies = new HashSet<ExtensionDependency>();
        for (DefaultCoreExtension coreExtension : extensions.values()) {
            for (ExtensionDependency dependency : coreExtension.getDependencies()) {
                if (extensions.containsKey(dependency.getId())) continue;
                dependencies.add(dependency);
            }
        }
        HashMap<String, Object[]> fileNames = new HashMap<String, Object[]>();
        HashMap<String, Object[]> guessedArtefacts = new HashMap<String, Object[]>();
        for (URL jarURL : jars) {
            try {
                int index;
                String path = jarURL.toURI().getPath();
                String filename = path.substring(path.lastIndexOf(47) + 1);
                String type = null;
                int extIndex = filename.lastIndexOf(46);
                if (extIndex != -1) {
                    type = filename.substring(extIndex + 1);
                    filename = filename.substring(0, extIndex);
                }
                if ((index = !filename.endsWith("-SNAPSHOT") ? filename.lastIndexOf(45) : filename.lastIndexOf(45, filename.length() - "-SNAPSHOT".length())) == -1) continue;
                fileNames.put(filename, new Object[]{jarURL});
                String artefactname = filename.substring(0, index);
                String version = filename.substring(index + 1);
                guessedArtefacts.put(artefactname, new Object[]{version, jarURL, type});
            }
            catch (Exception e) {
                this.logger.warn("Failed to parse resource name [{}]", (Object)jarURL, (Object)e);
            }
        }
        try {
            for (DefaultCoreExtension coreExtension : extensions.values()) {
                String artifactId = this.getArtifactId(coreExtension);
                Object[] artefact = (Object[])guessedArtefacts.get(artifactId);
                if (artefact == null) continue;
                if (coreExtension.getId().getVersion().getValue().charAt(0) == '$') {
                    coreExtension.setId(new ExtensionId(coreExtension.getId().getId(), (String)artefact[0]));
                    coreExtension.setGuessed(true);
                }
                if (coreExtension.getType().charAt(0) != '$') continue;
                coreExtension.setType((String)artefact[2]);
                coreExtension.setGuessed(true);
            }
            for (ExtensionDependency extensionDependency : dependencies) {
                Dependency dependency = extensionDependency instanceof MavenExtensionDependency ? ((MavenExtensionDependency)extensionDependency).getMavenDependency() : this.toDependency(extensionDependency.getId(), extensionDependency.getVersionConstraint().getValue(), null);
                String dependencyId = dependency.getGroupId() + ':' + dependency.getArtifactId();
                DefaultCoreExtension coreExtension = extensions.get(dependencyId);
                if (coreExtension != null) continue;
                String dependencyFileName = dependency.getArtifactId() + '-' + dependency.getVersion();
                if (dependency.getClassifier() != null) {
                    dependencyFileName = dependencyFileName + '-' + dependency.getClassifier();
                    dependencyId = dependencyId + ':' + dependency.getClassifier();
                }
                Object[] filenameArtifact = (Object[])fileNames.get(dependencyFileName);
                Object[] guessedArtefact = (Object[])guessedArtefacts.get(dependency.getArtifactId());
                if (filenameArtifact != null) {
                    coreExtension = new DefaultCoreExtension(repository, (URL)filenameArtifact[0], new ExtensionId(dependencyId, dependency.getVersion()), MavenUtils.packagingToType(dependency.getType()));
                    coreExtension.setGuessed(true);
                } else if (guessedArtefact != null) {
                    coreExtension = new DefaultCoreExtension(repository, (URL)guessedArtefact[1], new ExtensionId(dependencyId, (String)guessedArtefact[0]), MavenUtils.packagingToType(dependency.getType()));
                    coreExtension.setGuessed(true);
                }
                if (coreExtension == null) continue;
                extensions.put(dependencyId, coreExtension);
            }
        }
        catch (Exception e) {
            this.logger.warn("Failed to guess extra information about some extensions", (Throwable)e);
        }
    }
}

