/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension.internal;

import java.io.StreamTokenizer;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.xwiki.extension.AbstractExtension;
import org.xwiki.extension.Extension;
import org.xwiki.extension.ExtensionDependency;
import org.xwiki.properties.converter.ConversionException;

public final class ExtensionUtils {
    private ExtensionUtils() {
    }

    public static ExtensionDependency getDependency(ExtensionDependency dependency, Map<String, ExtensionDependency> managedDependencies, Extension extension) {
        ExtensionDependency managedDependency = managedDependencies.get(dependency.getId());
        if (managedDependency == null && dependency.getVersionConstraint() == null) {
            for (ExtensionDependency extensionManagedDependency : extension.getManagedDependencies()) {
                if (!extensionManagedDependency.getId().equals(dependency.getId())) continue;
                managedDependency = extensionManagedDependency;
            }
        }
        return managedDependency != null ? managedDependency : dependency;
    }

    public static Map<String, ExtensionDependency> append(Map<String, ExtensionDependency> managedDependencies, Extension extension) {
        HashMap<String, ExtensionDependency> newManagedDependencies = managedDependencies != null ? new HashMap<String, ExtensionDependency>(managedDependencies) : new HashMap();
        for (ExtensionDependency dependency : extension.getManagedDependencies()) {
            newManagedDependencies.put(dependency.getId(), dependency);
        }
        return newManagedDependencies;
    }

    public static <T> T importProperty(AbstractExtension extension, String propertySuffix) {
        return extension.removeProperty("xwiki.extension." + propertySuffix);
    }

    public static String importProperty(AbstractExtension extension, String propertySuffix, String def) {
        return StringUtils.defaultString((String)((String)ExtensionUtils.importProperty(extension, propertySuffix)), (String)def);
    }

    public static Collection<String> importProperty(AbstractExtension extension, String propertySuffix, Collection<String> def) {
        Object obj = ExtensionUtils.importProperty(extension, propertySuffix);
        if (obj == null) {
            return def;
        }
        if (obj instanceof Collection) {
            return (Collection)obj;
        }
        if (obj instanceof String[]) {
            return Arrays.asList((String[])obj);
        }
        return ExtensionUtils.importPropertyStringList(obj.toString(), true);
    }

    public static List<String> importPropertyStringList(String str, boolean trim) {
        try {
            int ttype;
            String cleanedString = str;
            if (trim) {
                cleanedString = cleanedString.trim();
            }
            StreamTokenizer st = new StreamTokenizer(new StringReader(cleanedString));
            st.ordinaryChars(0, 255);
            st.wordChars(0, 255);
            st.quoteChar(34);
            st.quoteChar(39);
            st.whitespaceChars(44, 44);
            st.whitespaceChars(32, 32);
            st.whitespaceChars(9, 9);
            st.whitespaceChars(10, 10);
            st.whitespaceChars(13, 13);
            ArrayList<String> collection = new ArrayList<String>();
            while ((ttype = st.nextToken()) == -3 || ttype > 0) {
                if (st.sval == null) continue;
                collection.add(st.sval);
            }
            if (ttype != -1) {
                throw new ConversionException("Encountered token of type " + ttype + " parsing elements.");
            }
            return collection;
        }
        catch (Exception exception) {
            return Collections.emptyList();
        }
    }
}

