/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension.job.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import javax.inject.Named;
import org.xwiki.component.annotation.Component;
import org.xwiki.extension.ExtensionId;
import org.xwiki.extension.InstallException;
import org.xwiki.extension.InstalledExtension;
import org.xwiki.extension.ResolveException;
import org.xwiki.extension.job.InstallRequest;
import org.xwiki.extension.job.internal.AbstractInstallPlanJob;
import org.xwiki.extension.repository.result.IterableResult;
import org.xwiki.extension.version.Version;
import org.xwiki.job.Request;

@Component
@Named(value="upgradeplan")
public class UpgradePlanJob
extends AbstractInstallPlanJob<InstallRequest> {
    public static final String JOBTYPE = "upgradeplan";

    public String getType() {
        return JOBTYPE;
    }

    protected InstallRequest castRequest(Request request) {
        InstallRequest installRequest = request instanceof InstallRequest ? (InstallRequest)request : new InstallRequest(request);
        return installRequest;
    }

    protected void upgradeExtension(InstalledExtension extension, String namespace, boolean filterDependencies) {
        if (!(((InstallRequest)this.getRequest()).getExcludedExtensions().contains(extension.getId()) || filterDependencies && extension.isDependency(namespace))) {
            try {
                IterableResult<Version> versions = this.repositoryManager.resolveVersions(extension.getId().getId(), 0, -1);
                if (versions.getSize() == 0) {
                    throw new ResolveException("Can't find any remote version for extension ([" + extension + "]");
                }
                ArrayList<Version> versionList = new ArrayList<Version>(versions.getSize());
                for (Version version : versions) {
                    versionList.add(version);
                }
                this.upgradeExtension(extension, namespace, versionList);
            }
            catch (ResolveException e) {
                this.logger.debug("Failed to resolve versions for extension id [{}]", (Object)extension.getId().getId(), (Object)e);
            }
        }
    }

    protected void upgradeExtension(InstalledExtension extension, String namespace, List<Version> versionList) {
        ListIterator<Version> it = versionList.listIterator(versionList.size());
        while (it.hasPrevious()) {
            Version version = it.previous();
            if (extension.getId().getVersion().compareTo(version) < 0 && (extension.getId().getVersion().getType().ordinal() > version.getType().ordinal() || !this.tryInstallExtension(new ExtensionId(extension.getId().getId(), version), namespace))) continue;
            break;
        }
    }

    protected boolean tryInstallExtension(ExtensionId extensionId, String namespace) {
        AbstractInstallPlanJob.ModifableExtensionPlanTree currentTree = this.extensionTree.clone();
        try {
            this.installExtension(extensionId, namespace, currentTree);
            this.setExtensionTree(currentTree);
            return true;
        }
        catch (InstallException e) {
            this.logger.debug("Can't install extension [{}] on namespace [{}].", new Object[]{extensionId, namespace, e});
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void upgrade(String namespace, Collection<InstalledExtension> installedExtensions, boolean filterDependencies) {
        this.progressManager.pushLevelProgress(installedExtensions.size(), (Object)this);
        try {
            for (InstalledExtension installedExtension : installedExtensions) {
                this.progressManager.startStep((Object)this);
                if (namespace != null && installedExtension.isInstalled(null)) continue;
                this.upgradeExtension(installedExtension, namespace, filterDependencies);
            }
        }
        finally {
            this.progressManager.popLevelProgress((Object)this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void upgrade(Collection<InstalledExtension> installedExtensions, boolean filterDependencies) {
        this.progressManager.pushLevelProgress(installedExtensions.size(), (Object)this);
        try {
            for (InstalledExtension installedExtension : installedExtensions) {
                this.progressManager.startStep((Object)this);
                if (installedExtension.getNamespaces() == null) {
                    this.upgradeExtension(installedExtension, null, filterDependencies);
                    continue;
                }
                this.progressManager.pushLevelProgress(installedExtension.getNamespaces().size(), (Object)this);
                try {
                    for (String namespace : installedExtension.getNamespaces()) {
                        this.progressManager.startStep((Object)this);
                        this.upgradeExtension(installedExtension, namespace, filterDependencies);
                    }
                }
                finally {
                    this.progressManager.popLevelProgress((Object)this);
                }
            }
        }
        finally {
            this.progressManager.popLevelProgress((Object)this);
        }
    }

    protected Collection<InstalledExtension> getInstalledExtensions(String namespace) {
        Collection<InstalledExtension> installedExtensions;
        Collection<ExtensionId> requestExtensions = ((InstallRequest)this.getRequest()).getExtensions();
        if (requestExtensions != null && !requestExtensions.isEmpty()) {
            installedExtensions = new ArrayList<InstalledExtension>(requestExtensions.size());
            for (ExtensionId requestExtension : requestExtensions) {
                InstalledExtension installedExtension = this.installedExtensionRepository.getInstalledExtension(requestExtension);
                if (!installedExtension.isInstalled(namespace)) continue;
                installedExtensions.add(installedExtension);
            }
        } else {
            installedExtensions = this.installedExtensionRepository.getInstalledExtensions(namespace);
        }
        return installedExtensions;
    }

    protected Collection<InstalledExtension> getInstalledExtensions() {
        Collection<InstalledExtension> installedExtensions;
        Collection<ExtensionId> requestExtensions = ((InstallRequest)this.getRequest()).getExtensions();
        if (requestExtensions != null && !requestExtensions.isEmpty()) {
            installedExtensions = new ArrayList<InstalledExtension>(requestExtensions.size());
            for (ExtensionId requestExtension : requestExtensions) {
                InstalledExtension installedExtension = this.installedExtensionRepository.getInstalledExtension(requestExtension);
                installedExtensions.add(installedExtension);
            }
        } else {
            installedExtensions = this.installedExtensionRepository.getInstalledExtensions();
        }
        return installedExtensions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void runInternal() throws Exception {
        boolean filterDependencies;
        Collection<String> namespaces = ((InstallRequest)this.getRequest()).getNamespaces();
        Collection<ExtensionId> requestExtensions = ((InstallRequest)this.getRequest()).getExtensions();
        boolean bl = filterDependencies = requestExtensions == null || requestExtensions.isEmpty();
        if (namespaces == null) {
            Collection<InstalledExtension> installedExtensions = this.getInstalledExtensions();
            this.upgrade(installedExtensions, filterDependencies);
        } else {
            this.progressManager.pushLevelProgress(namespaces.size(), (Object)this);
            try {
                for (String namespace : namespaces) {
                    this.progressManager.startStep((Object)this);
                    this.upgrade(namespace, this.getInstalledExtensions(namespace), filterDependencies);
                }
            }
            finally {
                this.progressManager.popLevelProgress((Object)this);
            }
        }
    }
}

