/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension.internal.maven;

import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.xwiki.extension.DefaultExtensionScmConnection;
import org.xwiki.extension.ExtensionScmConnection;

public class MavenUtils {
    public static final String MPKEYPREFIX = "xwiki.extension.";
    public static final String MPNAME_NAME = "name";
    public static final String MPNAME_SUMMARY = "summary";
    public static final String MPNAME_WEBSITE = "website";
    public static final String MPNAME_FEATURES = "features";
    public static final String MPNAME_CATEGORY = "category";
    public static final String PKEY_MAVEN_MODEL = "maven.Model";
    public static final String JAR_EXTENSION = "jar";
    public static final String JAVA_LANGUAGE = "java";
    public static final String MAVENPACKAGE = "META-INF.maven";
    public static final String SNAPSHOTSUFFIX = "-SNAPSHOT";
    public static final Pattern PARSER_ID = Pattern.compile("([^: ]+):([^: ]+)(:([^: ]+))?");
    public static final String MF_EXTENSION_ID = "XWiki-Extension-Id";

    public static ExtensionScmConnection toExtensionScmConnection(String connectionURL) {
        if (connectionURL == null) {
            return null;
        }
        String path = connectionURL;
        if (path.startsWith("scm:")) {
            path = path.substring("scm:".length());
        }
        String system = "git";
        int index = path.indexOf(58);
        if (index >= 0) {
            if (index != 0) {
                system = path.substring(0, index);
            }
            path = path.substring(index + 1);
        }
        return new DefaultExtensionScmConnection(system, path);
    }

    public static String toExtensionId(String groupId, String artifactId, String classifier) {
        StringBuilder builder = new StringBuilder();
        builder.append(groupId);
        builder.append(':');
        builder.append(artifactId);
        if (StringUtils.isNotEmpty((CharSequence)classifier)) {
            builder.append(':');
            builder.append(classifier);
        }
        return builder.toString();
    }

    public static String packagingToType(String packaging) {
        if (packaging.equals("bundle")) {
            return JAR_EXTENSION;
        }
        return packaging;
    }
}

