/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension.repository.internal.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.phase.Initializable;
import org.xwiki.component.phase.InitializationException;
import org.xwiki.extension.CoreExtension;
import org.xwiki.extension.Extension;
import org.xwiki.extension.ExtensionDependency;
import org.xwiki.extension.ExtensionId;
import org.xwiki.extension.ResolveException;
import org.xwiki.extension.repository.AbstractExtensionRepository;
import org.xwiki.extension.repository.CoreExtensionRepository;
import org.xwiki.extension.repository.DefaultExtensionRepositoryDescriptor;
import org.xwiki.extension.repository.ExtensionRepositoryManager;
import org.xwiki.extension.repository.internal.RepositoryUtils;
import org.xwiki.extension.repository.internal.core.CoreExtensionScanner;
import org.xwiki.extension.repository.internal.core.DefaultCoreExtension;
import org.xwiki.extension.repository.result.CollectionIterableResult;
import org.xwiki.extension.repository.result.IterableResult;
import org.xwiki.extension.repository.search.SearchException;
import org.xwiki.extension.repository.search.Searchable;
import org.xwiki.extension.version.Version;

@Component
@Singleton
public class DefaultCoreExtensionRepository
extends AbstractExtensionRepository
implements CoreExtensionRepository,
Initializable,
Searchable {
    protected transient Map<String, DefaultCoreExtension> extensions;
    protected transient DefaultCoreExtension environmentExtension;
    @Inject
    private transient Logger logger;
    @Inject
    private transient CoreExtensionScanner scanner;
    @Inject
    private ExtensionRepositoryManager repositoryManager;

    public DefaultCoreExtensionRepository() {
        super(new DefaultExtensionRepositoryDescriptor("core", "xwiki-core", null));
    }

    public void initialize() throws InitializationException {
        try {
            this.extensions = new ConcurrentHashMap<String, DefaultCoreExtension>(this.scanner.loadExtensions(this));
            this.environmentExtension = this.scanner.loadEnvironmentExtensions(this);
            if (this.environmentExtension != null) {
                this.extensions.put(this.environmentExtension.getId().getId(), this.environmentExtension);
            }
            for (DefaultCoreExtension extension : this.extensions.values()) {
                for (String feature : extension.getFeatures()) {
                    this.extensions.put(feature, extension);
                }
            }
            if (!this.repositoryManager.getRepositories().isEmpty()) {
                Thread thread = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        DefaultCoreExtensionRepository.this.scanner.updateExtensions(DefaultCoreExtensionRepository.this.extensions.values());
                    }
                });
                thread.setPriority(1);
                thread.setDaemon(true);
                thread.setName("Core extension repository updater");
                thread.start();
            }
        }
        catch (Exception e) {
            this.logger.warn("Failed to load core extensions", (Throwable)e);
        }
    }

    @Override
    public CoreExtension resolve(ExtensionId extensionId) throws ResolveException {
        CoreExtension extension = this.getCoreExtension(extensionId.getId());
        if (extension == null || extensionId.getVersion() != null && !extension.getId().getVersion().equals(extensionId.getVersion())) {
            throw new ResolveException("Could not find extension [" + extensionId + "]");
        }
        return extension;
    }

    @Override
    public CoreExtension resolve(ExtensionDependency extensionDependency) throws ResolveException {
        CoreExtension extension = this.getCoreExtension(extensionDependency.getId());
        if (extension == null || !extensionDependency.getVersionConstraint().containsVersion(extension.getId().getVersion())) {
            throw new ResolveException("Could not find extension dependency [" + extensionDependency + "]");
        }
        return extension;
    }

    @Override
    public boolean exists(ExtensionId extensionId) {
        CoreExtension extension = this.getCoreExtension(extensionId.getId());
        return extension != null && (extensionId.getVersion() == null || extension.getId().getVersion().equals(extensionId.getVersion()));
    }

    @Override
    public boolean exists(String feature) {
        return this.extensions.containsKey(feature);
    }

    @Override
    public IterableResult<Version> resolveVersions(String id, int offset, int nb) throws ResolveException {
        CoreExtension extension = this.getCoreExtension(id);
        if (extension == null) {
            throw new ResolveException("Could not find extension with id [" + id + "]");
        }
        List<Object> versions = nb == 0 || offset > 0 ? Collections.emptyList() : Arrays.asList(extension.getId().getVersion());
        return new CollectionIterableResult<Version>(1, offset, versions);
    }

    @Override
    public CoreExtension getEnvironmentExtension() {
        return this.environmentExtension;
    }

    @Override
    public int countExtensions() {
        return this.extensions.size();
    }

    @Override
    public Collection<CoreExtension> getCoreExtensions() {
        return new ArrayList<CoreExtension>(this.extensions.values());
    }

    @Override
    public CoreExtension getCoreExtension(String feature) {
        return this.extensions.get(feature);
    }

    @Override
    public IterableResult<Extension> search(String pattern, int offset, int nb) throws SearchException {
        return RepositoryUtils.searchInCollection(pattern, offset, nb, this.extensions.values(), true);
    }
}

