/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension.event;

import org.apache.commons.lang3.StringUtils;
import org.xwiki.extension.ExtensionId;
import org.xwiki.extension.event.ExtensionEvent;

public abstract class AbstractExtensionEvent
implements ExtensionEvent {
    private ExtensionId extensionId;
    private String namespace;
    private boolean noNamespace;

    public AbstractExtensionEvent() {
        this.noNamespace = true;
    }

    protected AbstractExtensionEvent(ExtensionId extensionId, String namespace) {
        this.extensionId = extensionId;
        this.namespace = namespace;
        this.noNamespace = false;
    }

    @Override
    public ExtensionId getExtensionId() {
        return this.extensionId;
    }

    @Override
    public String getNamespace() {
        return this.namespace;
    }

    @Override
    public boolean hasNamespace() {
        return !this.noNamespace;
    }

    public boolean matches(Object event) {
        return this.getClass() == event.getClass() && this.matchesExtensionId(((AbstractExtensionEvent)event).getExtensionId()) && this.matchesNamespace(((AbstractExtensionEvent)event).getNamespace());
    }

    private boolean matchesExtensionId(ExtensionId extensionId) {
        return this.extensionId == null || this.extensionId.equals(extensionId) || this.extensionId.getVersion() == null && this.extensionId.getId().equals(extensionId.getId());
    }

    private boolean matchesNamespace(String namespace) {
        return this.noNamespace || StringUtils.equals((CharSequence)this.namespace, (CharSequence)namespace);
    }
}

