/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension.job.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.ListIterator;
import javax.inject.Named;
import org.xwiki.component.annotation.Component;
import org.xwiki.extension.ExtensionId;
import org.xwiki.extension.InstallException;
import org.xwiki.extension.InstalledExtension;
import org.xwiki.extension.ResolveException;
import org.xwiki.extension.job.InstallRequest;
import org.xwiki.extension.job.internal.AbstractInstallPlanJob;
import org.xwiki.extension.repository.result.IterableResult;
import org.xwiki.extension.version.Version;
import org.xwiki.job.Request;

@Component
@Named(value="upgradeplan")
public class UpgradePlanJob
extends AbstractInstallPlanJob<InstallRequest> {
    public static final String JOBTYPE = "upgradeplan";

    public String getType() {
        return JOBTYPE;
    }

    protected InstallRequest castRequest(Request request) {
        InstallRequest installRequest = request instanceof InstallRequest ? (InstallRequest)request : new InstallRequest(request);
        return installRequest;
    }

    protected void upgradeExtension(InstalledExtension extension, String namespace) {
        if (!extension.isDependency(namespace)) {
            String extensionId = extension.getId().getId();
            try {
                IterableResult<Version> versions = this.repositoryManager.resolveVersions(extensionId, 0, -1);
                if (versions.getSize() == 0) {
                    throw new ResolveException("Can't find any remote version for extension ([" + extension + "]");
                }
                ArrayList<Version> versionList = new ArrayList<Version>(versions.getSize());
                for (Version version : versions) {
                    versionList.add(version);
                }
                ListIterator it = versionList.listIterator(versionList.size());
                while (it.hasPrevious()) {
                    Version version;
                    version = (Version)it.previous();
                    if (extension.getId().getVersion().compareTo(version) < 0 && (extension.getId().getVersion().getType().ordinal() > version.getType().ordinal() || !this.tryInstallExtension(new ExtensionId(extensionId, version), namespace))) continue;
                    break;
                }
            }
            catch (ResolveException e) {
                this.logger.debug("Failed to resolve versions for extension id [{}]", (Object)extensionId, (Object)e);
            }
        }
    }

    protected boolean tryInstallExtension(ExtensionId extensionId, String namespace) {
        AbstractInstallPlanJob.ModifableExtensionPlanTree currentTree = this.extensionTree.clone();
        try {
            this.installExtension(extensionId, namespace, currentTree);
            this.setExtensionTree(currentTree);
            return true;
        }
        catch (InstallException e) {
            this.logger.debug("Can't install extension [{}] on namespace [{}].", new Object[]{extensionId, namespace, e});
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void start() throws Exception {
        Collection<String> namespaces = ((InstallRequest)this.getRequest()).getNamespaces();
        if (namespaces == null) {
            Collection<InstalledExtension> installedExtensions = this.installedExtensionRepository.getInstalledExtensions();
            this.notifyPushLevelProgress(installedExtensions.size());
            try {
                for (InstalledExtension installedExtension : installedExtensions) {
                    if (installedExtension.getNamespaces() == null) {
                        this.upgradeExtension(installedExtension, null);
                    } else {
                        this.notifyPushLevelProgress(installedExtension.getNamespaces().size());
                        try {
                            for (String namespace : installedExtension.getNamespaces()) {
                                this.upgradeExtension(installedExtension, namespace);
                                this.notifyStepPropress();
                            }
                        }
                        finally {
                            this.notifyPopLevelProgress();
                        }
                    }
                    this.notifyStepPropress();
                }
            }
            finally {
                this.notifyPopLevelProgress();
            }
        }
        this.notifyPushLevelProgress(namespaces.size());
        try {
            for (String namespace : namespaces) {
                Collection<InstalledExtension> installedExtensions = this.installedExtensionRepository.getInstalledExtensions(namespace);
                this.notifyPushLevelProgress(installedExtensions.size());
                try {
                    for (InstalledExtension installedExtension : installedExtensions) {
                        this.upgradeExtension(installedExtension, namespace);
                        this.notifyStepPropress();
                    }
                }
                finally {
                    this.notifyPopLevelProgress();
                }
                this.notifyStepPropress();
            }
        }
        finally {
            this.notifyPopLevelProgress();
        }
    }
}

