/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension.job.internal;

import java.util.Collection;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import org.xwiki.component.annotation.Component;
import org.xwiki.extension.InstalledExtension;
import org.xwiki.extension.UninstallException;
import org.xwiki.extension.event.ExtensionUninstalledEvent;
import org.xwiki.extension.handler.ExtensionHandlerManager;
import org.xwiki.extension.job.UninstallRequest;
import org.xwiki.extension.job.internal.AbstractExtensionJob;
import org.xwiki.extension.job.plan.ExtensionPlan;
import org.xwiki.extension.job.plan.ExtensionPlanAction;
import org.xwiki.extension.repository.InstalledExtensionRepository;
import org.xwiki.job.Job;
import org.xwiki.job.Request;
import org.xwiki.logging.LogLevel;
import org.xwiki.logging.event.LogEvent;
import org.xwiki.observation.event.Event;

@Component
@Named(value="uninstall")
public class UninstallJob
extends AbstractExtensionJob<UninstallRequest> {
    public static final String JOBTYPE = "uninstall";
    @Inject
    private InstalledExtensionRepository installedExtensionRepository;
    @Inject
    private ExtensionHandlerManager extensionHandlerManager;
    @Inject
    @Named(value="uninstallplan")
    private Job uninstallPlanJob;

    public String getType() {
        return JOBTYPE;
    }

    protected UninstallRequest castRequest(Request request) {
        UninstallRequest uninstallRequest = request instanceof UninstallRequest ? (UninstallRequest)request : new UninstallRequest(request);
        return uninstallRequest;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void start() throws Exception {
        this.notifyPushLevelProgress(2);
        try {
            UninstallRequest planRequest = new UninstallRequest(this.getRequest());
            planRequest.setId(null);
            this.uninstallPlanJob.start((Request)planRequest);
            ExtensionPlan plan = (ExtensionPlan)this.uninstallPlanJob.getStatus();
            List log = plan.getLog(LogLevel.ERROR);
            if (!log.isEmpty()) {
                throw new UninstallException("Failed to create install plan: " + ((LogEvent)log.get(0)).getFormattedMessage(), ((LogEvent)log.get(0)).getThrowable());
            }
            this.notifyStepPropress();
            Collection<ExtensionPlanAction> actions = plan.getActions();
            this.notifyPushLevelProgress(actions.size());
            try {
                for (ExtensionPlanAction action : actions) {
                    if (action.getAction() != ExtensionPlanAction.Action.NONE) {
                        this.applyAction(action);
                    }
                    this.notifyStepPropress();
                }
            }
            finally {
                this.notifyPopLevelProgress();
            }
        }
        finally {
            this.notifyPopLevelProgress();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void applyAction(ExtensionPlanAction action) throws UninstallException {
        if (action.getAction() != ExtensionPlanAction.Action.UNINSTALL) {
            throw new UninstallException("Unsupported action [" + (Object)((Object)action.getAction()) + "]");
        }
        InstalledExtension installedExtension = (InstalledExtension)action.getExtension();
        String namespace = action.getNamespace();
        if (namespace != null) {
            this.logger.info("Uninstalling extension [{}] from namespace [{}]", (Object)installedExtension.toString(), (Object)namespace);
        } else {
            this.logger.info("Uninstalling extension [{}]", (Object)installedExtension.toString());
        }
        this.notifyPushLevelProgress(2);
        try {
            this.extensionHandlerManager.uninstall(installedExtension, namespace, this.getRequest());
            this.notifyStepPropress();
            this.installedExtensionRepository.uninstallExtension(installedExtension, namespace);
            this.observationManager.notify((Event)new ExtensionUninstalledEvent(installedExtension.getId(), namespace), (Object)installedExtension);
            if (namespace != null) {
                this.logger.info("Successfully uninstalled extension [{}] from namespace [{}]", (Object)installedExtension.toString(), (Object)namespace);
            } else {
                this.logger.info("Successfully uninstalled extension [{}]", (Object)installedExtension.toString());
            }
        }
        finally {
            this.notifyPopLevelProgress();
        }
    }
}

