/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension.version.internal;

import java.util.Collection;
import org.xwiki.extension.version.Version;
import org.xwiki.extension.version.VersionConstraint;
import org.xwiki.extension.version.VersionRange;
import org.xwiki.extension.version.VersionRangeCollection;
import org.xwiki.extension.version.internal.DefaultVersionRange;

public final class VersionUtils {
    private VersionUtils() {
    }

    public static boolean startsWith(String str, char c) {
        return str.length() > 0 && str.charAt(0) == c;
    }

    public static boolean endsWith(String str, char c) {
        return str.length() > 0 && str.charAt(str.length() - 1) == c;
    }

    public static Version getStrictVersion(Collection<? extends VersionRangeCollection> ranges) {
        for (VersionRangeCollection versionRangeCollection : ranges) {
            DefaultVersionRange defaultRange;
            Version lowerBound;
            VersionRange range;
            if (versionRangeCollection.getRanges().size() != 1 || !((range = versionRangeCollection.getRanges().iterator().next()) instanceof DefaultVersionRange) || (lowerBound = (defaultRange = (DefaultVersionRange)range).getLowerBound()) == null || !lowerBound.equals(defaultRange.getUpperBound())) continue;
            return lowerBound;
        }
        return null;
    }

    public static Version getUniqueVersion(VersionConstraint constraint) {
        if (constraint == null) {
            return null;
        }
        return constraint.getVersion() != null ? constraint.getVersion() : VersionUtils.getStrictVersion(constraint.getRanges());
    }
}

