/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension.internal.converter;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.extension.ExtensionId;
import org.xwiki.extension.internal.ExtensionFactory;
import org.xwiki.extension.internal.converter.ExtensionConverterParser;
import org.xwiki.extension.version.Version;
import org.xwiki.extension.version.internal.DefaultVersion;
import org.xwiki.properties.converter.AbstractConverter;

@Component
@Singleton
public class ExtensionIdConverter
extends AbstractConverter<ExtensionId> {
    @Inject
    private ExtensionFactory factory;

    public static List<ExtensionId> toExtensionIdList(Collection<?> values, Version defaultVersion) {
        return ExtensionIdConverter.toExtensionIdList(values, defaultVersion, null);
    }

    public static List<ExtensionId> toExtensionIdList(Collection<?> values, Version defaultVersion, ExtensionFactory factory) {
        ArrayList<ExtensionId> list = new ArrayList<ExtensionId>(values.size());
        for (Object value : values) {
            list.add(ExtensionIdConverter.toExtensionId(value, defaultVersion, factory));
        }
        return list;
    }

    public static ExtensionId toExtensionId(Object value, Version defaultVersion) {
        return ExtensionIdConverter.toExtensionId(value, defaultVersion, null);
    }

    public static ExtensionId toExtensionId(Object value, Version defaultVersion, ExtensionFactory factory) {
        if (value != null) {
            String valueString = value.toString();
            ExtensionConverterParser parser = new ExtensionConverterParser(valueString);
            String id = parser.next(true);
            String versionString = parser.next(false);
            Version version = versionString != null ? (factory != null ? factory.getVersion(versionString) : new DefaultVersion(versionString)) : defaultVersion;
            return new ExtensionId(id, version);
        }
        return null;
    }

    public static String toString(ExtensionId value) {
        return ExtensionConverterParser.toString(value.getId(), value.getVersion());
    }

    public static List<String> toStringList(Collection<ExtensionId> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (ExtensionId value : values) {
            list.add(ExtensionIdConverter.toString(value));
        }
        return list;
    }

    protected ExtensionId convertToType(Type targetType, Object value) {
        return ExtensionIdConverter.toExtensionId(value, null, this.factory);
    }

    protected String convertToString(ExtensionId value) {
        return ExtensionIdConverter.toString(value);
    }
}

