/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension.repository.internal.local;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.DirectoryNotEmptyException;
import java.nio.file.Files;
import java.nio.file.Path;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.extension.ExtensionId;
import org.xwiki.extension.InvalidExtensionException;
import org.xwiki.extension.internal.PathUtils;
import org.xwiki.extension.repository.internal.ExtensionSerializer;
import org.xwiki.extension.repository.internal.local.DefaultLocalExtension;
import org.xwiki.extension.repository.internal.local.DefaultLocalExtensionFile;
import org.xwiki.extension.repository.internal.local.DefaultLocalExtensionRepository;

public class LocalExtensionStorage {
    private static final Logger LOGGER = LoggerFactory.getLogger(LocalExtensionStorage.class);
    private static final String DESCRIPTOR_EXT = "xed";
    private static final String DESCRIPTOR_SUFFIX = ".xed";
    private DefaultLocalExtensionRepository repository;
    private ExtensionSerializer extensionSerializer;
    private File rootFolder;

    public LocalExtensionStorage(DefaultLocalExtensionRepository repository, File rootFolder, ComponentManager componentManager) throws ComponentLookupException {
        this.repository = repository;
        this.rootFolder = rootFolder;
        this.extensionSerializer = (ExtensionSerializer)componentManager.getInstance(ExtensionSerializer.class);
    }

    public File getRootFolder() {
        return this.rootFolder;
    }

    protected void loadExtensions() throws IOException {
        if (this.rootFolder.exists()) {
            this.loadExtensions(this.rootFolder);
        } else {
            this.rootFolder.mkdirs();
        }
    }

    protected void loadExtensions(File folder) throws IOException {
        if (!this.rootFolder.exists()) {
            throw new IOException("Directory does not exist: " + this.rootFolder);
        }
        if (!this.rootFolder.isDirectory()) {
            throw new IOException("Not a directory: " + this.rootFolder);
        }
        File[] files = folder.listFiles();
        if (files == null) {
            throw new IOException("Could not list files: " + this.rootFolder);
        }
        for (File child : files) {
            if (child.isDirectory()) {
                this.loadExtensions(child);
                continue;
            }
            if (!child.getName().endsWith(DESCRIPTOR_SUFFIX)) continue;
            try {
                DefaultLocalExtension localExtension = this.loadDescriptor(child);
                this.repository.addLocalExtension(localExtension);
            }
            catch (Exception e) {
                LOGGER.warn("Failed to load extension from file [" + child + "] in local repository", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DefaultLocalExtension loadDescriptor(File descriptor) throws InvalidExtensionException {
        FileInputStream fis;
        try {
            fis = new FileInputStream(descriptor);
        }
        catch (FileNotFoundException e) {
            throw new InvalidExtensionException("Failed to open descriptor for reading", e);
        }
        try {
            DefaultLocalExtension localExtension = this.extensionSerializer.loadLocalExtensionDescriptor(this.repository, fis);
            localExtension.setDescriptorFile(descriptor);
            File extensionFile = this.getFile(descriptor, DESCRIPTOR_EXT, localExtension.getType());
            if (extensionFile != null) {
                localExtension.setFile(extensionFile);
                if (!localExtension.getFile().getFile().exists()) {
                    throw new InvalidExtensionException("Failed to load local extension [" + descriptor + "]: [" + localExtension.getFile() + "] file does not exist");
                }
            }
            DefaultLocalExtension defaultLocalExtension = localExtension;
            return defaultLocalExtension;
        }
        finally {
            try {
                fis.close();
            }
            catch (IOException e) {
                LOGGER.error("Failed to close stream for file [" + descriptor + "]", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveDescriptor(DefaultLocalExtension extension) throws ParserConfigurationException, TransformerException, IOException {
        File file = extension.getDescriptorFile();
        if (file == null) {
            file = this.getNewDescriptorFile(extension.getId());
            extension.setDescriptorFile(file);
        }
        file.getParentFile().mkdirs();
        try (FileOutputStream fos = new FileOutputStream(file);){
            this.extensionSerializer.saveExtensionDescriptor(extension, fos);
        }
    }

    protected File getNewExtensionFile(ExtensionId id, String type) {
        return new File(this.getRootFolder(), this.getFilePath(id, type));
    }

    private File getNewDescriptorFile(ExtensionId id) {
        return new File(this.getRootFolder(), this.getFilePath(id, DESCRIPTOR_EXT));
    }

    private File getFile(File baseFile, String baseType, String type) {
        if (StringUtils.isEmpty((CharSequence)type)) {
            return null;
        }
        String baseName = this.getBaseName(baseFile.getName(), baseType);
        return new File(baseFile.getParent(), baseName + "." + PathUtils.encode(type));
    }

    private String getBaseName(String fileName, String type) {
        return fileName.substring(0, fileName.length() - PathUtils.encode(type).length() - 1);
    }

    private String getFilePath(ExtensionId id, String fileExtension) {
        String encodedId = PathUtils.encode(id.getId());
        String encodedVersion = PathUtils.encode(id.getVersion().toString());
        String encodedType = PathUtils.encode(fileExtension);
        return encodedId + File.separator + encodedVersion + File.separator + encodedId + "-" + encodedVersion + "." + encodedType;
    }

    public void removeExtension(DefaultLocalExtension extension) throws IOException {
        File descriptorFile = extension.getDescriptorFile();
        if (descriptorFile == null) {
            throw new IOException(String.format("Extension [%s] does not exist: descriptor file is null", extension.getId().getId()));
        }
        Path extensionDescriptorFilePath = descriptorFile.toPath();
        try {
            Files.delete(extensionDescriptorFilePath);
        }
        catch (FileNotFoundException e) {
            LOGGER.warn("Couldn't delete the extension descriptor file [{}] when removing extension [{}], because it doesn't exist. Root error: [{}]", new Object[]{descriptorFile.getAbsolutePath(), extension.getId().getId(), ExceptionUtils.getRootCauseMessage((Throwable)e)});
        }
        DefaultLocalExtensionFile extensionFile = extension.getFile();
        if (extensionFile != null) {
            try {
                Files.delete(extensionFile.getFile().toPath());
            }
            catch (FileNotFoundException e) {
                LOGGER.warn("Extension file [{}] was not found while removing [{}] extension", (Object)extensionFile.getAbsolutePath(), (Object)extension.getId().getId());
            }
        }
        Path extensionVersionFolderPath = extensionDescriptorFilePath.getParent();
        try {
            Files.delete(extensionDescriptorFilePath);
            LocalExtensionStorage.deleteExtensionFolderIfEmpty(extensionVersionFolderPath.getParent());
        }
        catch (DirectoryNotEmptyException e) {
            LOGGER.warn("Extension version folder [{}] was not empty after removing the extension [{}]. Keeping it.", (Object)extensionDescriptorFilePath, (Object)extension.getId().getId());
        }
    }

    private static void deleteExtensionFolderIfEmpty(Path extensionFolderPath) throws IOException {
        try {
            Files.delete(extensionFolderPath);
        }
        catch (DirectoryNotEmptyException e) {
            LOGGER.debug("Extension folder [{}] was not empty after removing the extension. Keeping it.", (Object)extensionFolderPath);
        }
    }
}

