/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension.internal.converter;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.extension.DefaultExtensionComponent;
import org.xwiki.extension.ExtensionComponent;
import org.xwiki.extension.internal.converter.ExtensionConverterParser;
import org.xwiki.properties.converter.AbstractConverter;

@Component
@Singleton
public class ExtensionComponentConverter
extends AbstractConverter<ExtensionComponent> {
    public static List<ExtensionComponent> toExtensionComponentList(Collection<?> values) {
        ArrayList<ExtensionComponent> list = new ArrayList<ExtensionComponent>(values.size());
        for (Object value : values) {
            list.add(ExtensionComponentConverter.toExtensionComponent(value));
        }
        return list;
    }

    public static ExtensionComponent toExtensionComponent(Object value) {
        if (value != null) {
            String valueString = value.toString();
            ExtensionConverterParser parser = new ExtensionConverterParser(valueString);
            return new DefaultExtensionComponent(parser.next(true), parser.next(false));
        }
        return null;
    }

    public static String toString(ExtensionComponent value) {
        StringBuilder builder = new StringBuilder();
        builder.append(value.getRoleType());
        if (value.getRoleHint() != null) {
            builder.append('/');
            builder.append(value.getRoleHint());
        }
        return builder.toString();
    }

    public static List<String> toStringList(Collection<ExtensionComponent> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (ExtensionComponent value : values) {
            list.add(ExtensionComponentConverter.toString(value));
        }
        return list;
    }

    protected ExtensionComponent convertToType(Type targetType, Object value) {
        return ExtensionComponentConverter.toExtensionComponent(value);
    }

    protected String convertToString(ExtensionComponent value) {
        return ExtensionComponentConverter.toString(value);
    }
}

