/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.environment.internal;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import javax.inject.Singleton;
import javax.servlet.ServletContext;
import org.xwiki.component.annotation.Component;
import org.xwiki.environment.internal.AbstractEnvironment;

@Component
@Singleton
public class ServletEnvironment
extends AbstractEnvironment {
    private ServletContext servletContext;

    public void setServletContext(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    public ServletContext getServletContext() {
        if (this.servletContext == null) {
            throw new RuntimeException("The Servlet Environment has not been properly initialized (The Servlet Context is not set)");
        }
        return this.servletContext;
    }

    public InputStream getResourceAsStream(String resourceName) {
        return this.getServletContext().getResourceAsStream(resourceName);
    }

    public URL getResource(String resourceName) {
        try {
            return this.getServletContext().getResource(resourceName);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(String.format("Failed to access resource [%s]", resourceName), e);
        }
    }

    protected String getTemporaryDirectoryName() {
        String tmpDirectory = super.getTemporaryDirectoryName();
        try {
            if (tmpDirectory == null) {
                return ((File)this.getServletContext().getAttribute("javax.servlet.context.tempdir")).getCanonicalPath();
            }
        }
        catch (IOException e) {
            this.logger.warn("Unable to get servlet temporary directory due to error [{}], falling back on default temp directory.", (Object)e.getMessage());
        }
        return tmpDirectory;
    }
}

