/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.environment.internal;

import java.io.File;
import java.io.IOException;
import javax.inject.Inject;
import javax.inject.Provider;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.xwiki.environment.Environment;
import org.xwiki.environment.internal.EnvironmentConfiguration;

public abstract class AbstractEnvironment
implements Environment {
    private static final String DEFAULT_TMP_DIRECTORY = System.getProperty("java.io.tmpdir");
    private static final String TEMP_NAME = "xwiki-temp";
    @Inject
    protected Logger logger;
    @Inject
    private Provider<EnvironmentConfiguration> configurationProvider;
    private File temporaryDirectory;
    private File permanentDirectory;

    public void setPermanentDirectory(File permanentDirectory) {
        this.permanentDirectory = permanentDirectory;
    }

    public void setTemporaryDirectory(File temporaryDirectory) {
        this.temporaryDirectory = temporaryDirectory;
    }

    public File getPermanentDirectory() {
        if (this.permanentDirectory == null) {
            String systemProperty = System.getProperty("xwiki.data.dir");
            String classSpecified = this.getPermanentDirectoryName();
            String configured = ((EnvironmentConfiguration)this.configurationProvider.get()).getPermanentDirectoryPath();
            if (systemProperty == null && classSpecified == null && configured == null) {
                this.logger.warn("No permanent directory configured. Using temporary directory [{}].", (Object)DEFAULT_TMP_DIRECTORY);
            }
            String[] locations = new String[]{systemProperty, classSpecified, configured, this.getTemporaryDirectoryName(), DEFAULT_TMP_DIRECTORY};
            this.permanentDirectory = this.initializeDirectory(locations, false);
        }
        return this.permanentDirectory;
    }

    protected String getPermanentDirectoryName() {
        return null;
    }

    public File getTemporaryDirectory() {
        if (this.temporaryDirectory == null) {
            String[] locations = new String[]{this.getTemporaryDirectoryName(), DEFAULT_TMP_DIRECTORY};
            this.temporaryDirectory = this.initializeDirectory(locations, true);
        }
        return this.temporaryDirectory;
    }

    protected String getTemporaryDirectoryName() {
        return null;
    }

    private File initializeDirectory(String[] locations, boolean isTemp) {
        String tempOrPermanent = isTemp ? "temporary" : "permanent";
        boolean first = true;
        for (String location : locations) {
            if (location == null) continue;
            if (!first) {
                this.logger.warn("Falling back on [{}] as the {} directory.", (Object)location, (Object)tempOrPermanent);
            }
            first = false;
            File dir = this.initializeDirectory(location, isTemp, tempOrPermanent);
            if (dir == null) continue;
            return dir;
        }
        throw new RuntimeException(String.format("Could not find a writable %s directory. Check the server logs for more information.", tempOrPermanent));
    }

    private File initializeDirectory(String directoryName, boolean isTemp, String tempOrPermanent) {
        File dir;
        File file = dir = isTemp ? new File(directoryName, TEMP_NAME) : new File(directoryName);
        if (dir.exists()) {
            if (dir.isDirectory() && dir.canWrite()) {
                return this.initDir(dir, isTemp);
            }
            Object[] params = new String[]{tempOrPermanent, dir.getAbsolutePath(), dir.isDirectory() ? "not writable" : "not a directory"};
            this.logger.error("Configured {} directory [{}] is {}.", params);
            return null;
        }
        if (dir.mkdirs()) {
            return this.initDir(dir, isTemp);
        }
        this.logger.error("Configured {} directory [{}] could not be created, check permissions.", (Object)tempOrPermanent, (Object)dir.getAbsolutePath());
        return null;
    }

    private File initDir(File directory, boolean isTemp) {
        if (isTemp) {
            try {
                FileUtils.cleanDirectory((File)directory);
            }
            catch (IOException e) {
                throw new RuntimeException(String.format("Failed to empty the temporary directory [%s]. Are there files inside of it which XWiki does not have permission to delete?", directory.getAbsolutePath()));
            }
        }
        return directory;
    }
}

