/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.environment.internal;

import java.io.File;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.configuration.ConfigurationSource;
import org.xwiki.environment.EnvironmentConfiguration;

@Component
@Singleton
public class DefaultEnvironmentConfiguration
implements EnvironmentConfiguration {
    private static final String PROPERTY_PERMANENTDIRECTORY = "environment.permanentDirectory";
    @Inject
    private Logger logger;
    @Inject
    private Provider<ConfigurationSource> configurationSourceProvider;

    protected ConfigurationSource getConfigurationSource() {
        return (ConfigurationSource)this.configurationSourceProvider.get();
    }

    @Override
    public File getPermanentDirectory() {
        return this.initializeDirectory((String)this.getConfigurationSource().getProperty(PROPERTY_PERMANENTDIRECTORY, String.class));
    }

    protected File initializeDirectory(String directoryName) {
        File directory = null;
        if (directoryName != null) {
            directory = new File(directoryName);
            if (directory.exists()) {
                if (!directory.isDirectory()) {
                    this.logger.error("Configured permanent directory [{}] is not a directory", (Object)directory.getAbsolutePath());
                    directory = null;
                } else if (!directory.canWrite()) {
                    this.logger.error("Configured permanent directory [{}] is not writable", (Object)directory.getAbsolutePath());
                    directory = null;
                }
            } else {
                directory.mkdirs();
            }
        }
        return directory;
    }
}

