/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.diff.xml.internal;

import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.UserDataHandler;
import org.xwiki.component.annotation.Component;
import org.xwiki.diff.xml.XMLDiffFilter;
import org.xwiki.diff.xml.internal.DataURIConverter;
import org.xwiki.diff.xml.internal.XMLDiffUtils;

@Component
@Singleton
@Named(value="html/imageEmbedder")
public class HTMLImageEmbedder
implements XMLDiffFilter {
    private static final String ATTRIBUTE_SRC = "src";
    private static final String USER_DATA_IMAGE_SRC = "xwiki-html-diff-image-src";
    private static final String USER_DATA_IMAGE_DATA_URI = "xwiki-html-diff-image-dataURI";
    private static final UserDataHandler USER_DATA_HANDLER = new UserDataHandler(){

        @Override
        public void handle(short operation, String key, Object data, Node source, Node destination) {
            if (operation == 1) {
                destination.setUserData(key, data, this);
            }
        }
    };
    @Inject
    private Logger logger;
    @Inject
    private Provider<DataURIConverter> dataURIConverterProvider;

    @Override
    public void before(Document document) {
        this.getImages(document).forEach(this::before);
    }

    @Override
    public void after(Document document) {
        this.getImages(document).forEach(this::after);
    }

    private List<Element> getImages(Document document) {
        return XMLDiffUtils.asList(document.getElementsByTagName("img")).stream().map(image -> (Element)image).collect(Collectors.toList());
    }

    private void before(Element image) {
        String source = image.getAttribute(ATTRIBUTE_SRC);
        try {
            String dataURI = ((DataURIConverter)this.dataURIConverterProvider.get()).convert(source);
            image.setAttribute(ATTRIBUTE_SRC, dataURI);
            image.setUserData(USER_DATA_IMAGE_DATA_URI, dataURI, USER_DATA_HANDLER);
            image.setUserData(USER_DATA_IMAGE_SRC, source, USER_DATA_HANDLER);
        }
        catch (Exception e) {
            this.logger.warn("Failed to embed image [{}]. Root cause is [{}].", (Object)source, (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
        }
    }

    private void after(Element image) {
        String source = (String)image.getUserData(USER_DATA_IMAGE_SRC);
        String dataURI = (String)image.getUserData(USER_DATA_IMAGE_DATA_URI);
        if (source != null && image.getAttribute(ATTRIBUTE_SRC).equals(dataURI)) {
            image.setAttribute(ATTRIBUTE_SRC, source);
        }
    }
}

