/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.diff.xml.internal;

import difflib.DiffUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Singleton;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xwiki.component.annotation.Component;
import org.xwiki.diff.Chunk;
import org.xwiki.diff.Delta;
import org.xwiki.diff.DiffException;
import org.xwiki.diff.Patch;
import org.xwiki.diff.internal.ChangeDelta;
import org.xwiki.diff.internal.DefaultChunk;
import org.xwiki.diff.internal.DefaultPatch;
import org.xwiki.diff.internal.DeleteDelta;
import org.xwiki.diff.internal.InsertDelta;
import org.xwiki.diff.xml.StringSplitter;
import org.xwiki.diff.xml.XMLDiff;
import org.xwiki.diff.xml.XMLDiffConfiguration;
import org.xwiki.diff.xml.internal.XMLDiffUtils;

@Component
@Singleton
public class DefaultXMLDiff
implements XMLDiff {
    @Override
    public void xxx() {
    }

    @Override
    public Map<Node, Patch<?>> diff(Node left, Node right, XMLDiffConfiguration config) throws DiffException {
        LinkedHashMap patches = new LinkedHashMap();
        DefaultPatch rootPatch = new DefaultPatch();
        if (this.areSimilar(left, right)) {
            if (left != null) {
                patches.putAll(this.diffSimilarNodes(left, right, config));
            }
        } else if (left == null) {
            rootPatch.add((Object)new InsertDelta((Chunk)new DefaultChunk(-1, Collections.emptyList()), (Chunk)new DefaultChunk(XMLDiffUtils.getNodeIndex(right), Collections.singletonList(right))));
        } else if (right == null) {
            rootPatch.add((Object)new DeleteDelta((Chunk)new DefaultChunk(XMLDiffUtils.getNodeIndex(left), Collections.singletonList(left)), (Chunk)new DefaultChunk(-1, Collections.emptyList())));
        } else {
            rootPatch.add((Object)new ChangeDelta((Chunk)new DefaultChunk(XMLDiffUtils.getNodeIndex(left), Collections.singletonList(left)), (Chunk)new DefaultChunk(XMLDiffUtils.getNodeIndex(right), Collections.singletonList(right))));
        }
        if (!rootPatch.isEmpty()) {
            patches.put((Node)null, (Patch<?>)rootPatch);
        }
        return patches;
    }

    private Map<Node, Patch<?>> diffSimilarNodes(Node left, Node right, XMLDiffConfiguration config) throws DiffException {
        LinkedHashMap patches = new LinkedHashMap();
        if (left.getNodeValue() != null) {
            if (!left.getNodeValue().equals(right.getNodeValue())) {
                StringSplitter splitter = config.getSplitterForNodeType(left.getNodeType());
                patches.put(left, this.diff(left.getNodeValue(), right.getNodeValue(), splitter));
            }
        } else {
            if (left.getAttributes() != null) {
                this.extend(patches, this.diff(left.getAttributes(), right.getAttributes(), config), left);
            }
            this.extend(patches, this.diff(left.getChildNodes(), right.getChildNodes(), config), left);
        }
        return patches;
    }

    @Override
    public Map<Node, Patch<?>> diff(NodeList left, NodeList right, XMLDiffConfiguration config) throws DiffException {
        return this.diff(XMLDiffUtils.asList(left), XMLDiffUtils.asList(right), config);
    }

    @Override
    public Map<Node, Patch<?>> diff(NamedNodeMap left, NamedNodeMap right, XMLDiffConfiguration config) throws DiffException {
        return this.diff(this.asMap(left), this.asMap(right), config);
    }

    private Map<String, Node> asMap(NamedNodeMap namedNodeMap) {
        HashMap<String, Node> map = new HashMap<String, Node>();
        for (int i = 0; i < namedNodeMap.getLength(); ++i) {
            Node node = namedNodeMap.item(i);
            map.put(node.getNodeName(), node);
        }
        return map;
    }

    protected Patch<?> diff(String left, String right, StringSplitter splitter) throws DiffException {
        return new DefaultPatch(DiffUtils.diff(splitter.split(left), splitter.split(right)));
    }

    protected Map<Node, Patch<?>> diff(List<Node> left, List<Node> right, XMLDiffConfiguration config) throws DiffException {
        LinkedHashMap patches = new LinkedHashMap();
        DefaultPatch patch = new DefaultPatch(DiffUtils.diff(left, right, (alice, bob) -> this.areVerySimilar((Node)alice, (Node)bob, config)));
        Set leftModified = patch.stream().map(Delta::getPrevious).map(Chunk::getElements).flatMap(Collection::stream).collect(Collectors.toSet());
        Set rightModified = patch.stream().map(Delta::getNext).map(Chunk::getElements).flatMap(Collection::stream).collect(Collectors.toSet());
        ArrayList<Node> leftVerySimilar = new ArrayList<Node>(left);
        leftVerySimilar.removeAll(leftModified);
        ArrayList<Node> rightVerySimilar = new ArrayList<Node>(right);
        rightVerySimilar.removeAll(rightModified);
        assert (leftVerySimilar.size() == rightVerySimilar.size());
        for (int i = 0; i < leftVerySimilar.size(); ++i) {
            patches.putAll(this.diff((Node)leftVerySimilar.get(i), (Node)rightVerySimilar.get(i), config));
        }
        this.addPatch((Patch<Node>)patch, patches, config);
        return patches;
    }

    protected Map<Node, Patch<?>> diff(Map<String, Node> left, Map<String, Node> right, XMLDiffConfiguration config) throws DiffException {
        LinkedHashMap patches = new LinkedHashMap();
        DefaultPatch patch = new DefaultPatch();
        HashSet<String> deletedKeys = new HashSet<String>(left.keySet());
        deletedKeys.removeAll(right.keySet());
        if (!deletedKeys.isEmpty()) {
            List deletedNodes = deletedKeys.stream().map(left::get).collect(Collectors.toList());
            patch.add((Object)new DeleteDelta((Chunk)new DefaultChunk(-1, deletedNodes), (Chunk)new DefaultChunk(-1, Collections.emptyList())));
        }
        HashSet<String> insertedKeys = new HashSet<String>(right.keySet());
        insertedKeys.removeAll(left.keySet());
        if (!insertedKeys.isEmpty()) {
            List insertedNodes = insertedKeys.stream().map(right::get).collect(Collectors.toList());
            patch.add((Object)new InsertDelta((Chunk)new DefaultChunk(-1, Collections.emptyList()), (Chunk)new DefaultChunk(-1, insertedNodes)));
        }
        this.addPatch((Patch<Node>)patch, patches, config);
        HashSet<String> keptKeys = new HashSet<String>(left.keySet());
        keptKeys.retainAll(right.keySet());
        for (String keptKey : keptKeys) {
            patches.putAll(this.diff(left.get(keptKey), right.get(keptKey), config));
        }
        return patches;
    }

    protected boolean areSimilar(Node left, Node right) {
        return left == right || left != null && right != null && new EqualsBuilder().append(left.getNodeType(), right.getNodeType()).append((Object)left.getNodeName(), (Object)right.getNodeName()).append((Object)left.getLocalName(), (Object)right.getLocalName()).append((Object)left.getNamespaceURI(), (Object)right.getNamespaceURI()).append((Object)left.getPrefix(), (Object)right.getPrefix()).isEquals();
    }

    protected boolean areSimilar(List<Node> left, List<Node> right) {
        if (left.size() != right.size()) {
            return false;
        }
        for (int i = 0; i < left.size(); ++i) {
            if (this.areSimilar(left.get(i), right.get(i))) continue;
            return false;
        }
        return true;
    }

    protected boolean areVerySimilar(Node left, Node right, XMLDiffConfiguration config) {
        return this.areSimilar(left, right) && (left == null || this.getDiffPercentage(left.getTextContent(), right.getTextContent(), config) < config.getSimilarityThreshold());
    }

    private double getDiffPercentage(String left, String right, XMLDiffConfiguration config) {
        if (left != null && right != null) {
            List<Object> rightList;
            StringSplitter splitter = config.getSplitterForNodeType((short)3);
            List<Object> leftList = splitter.split(left);
            if (leftList.equals(rightList = splitter.split(right))) {
                return 0.0;
            }
            int maxLength = Math.max(leftList.size(), rightList.size());
            try {
                DefaultPatch patch = new DefaultPatch(DiffUtils.diff(leftList, rightList));
                int levenshteinDistance = patch.stream().map(delta -> Math.max(delta.getPrevious().size(), delta.getNext().size())).reduce(0, Integer::sum);
                return (double)levenshteinDistance / (double)maxLength;
            }
            catch (DiffException e) {
                return 1.0;
            }
        }
        if (left == right) {
            return 0.0;
        }
        return 1.0;
    }

    private void extend(Map<Node, Patch<?>> left, Map<Node, Patch<?>> right, Node context) {
        for (Map.Entry<Node, Patch<?>> entry : right.entrySet()) {
            Node key = entry.getKey() != null ? entry.getKey() : context;
            Patch patch = (Patch)left.getOrDefault(key, (Patch<?>)new DefaultPatch());
            patch.addAll((Collection)((List)entry.getValue()));
            left.put(key, patch);
        }
    }

    private void addPatch(Patch<Node> patch, Map<Node, Patch<?>> patches, XMLDiffConfiguration config) throws DiffException {
        ArrayList<Delta> deltasToRemove = new ArrayList<Delta>();
        for (Delta delta : patch) {
            if (delta.getType() != Delta.Type.CHANGE || !this.areSimilar(delta.getPrevious().getElements(), delta.getNext().getElements())) continue;
            deltasToRemove.add(delta);
            for (int i = 0; i < delta.getPrevious().size(); ++i) {
                Node left = (Node)delta.getPrevious().getElements().get(i);
                Node right = (Node)delta.getNext().getElements().get(i);
                this.extend(patches, this.diff(left, right, config), left);
            }
        }
        patch.removeAll(deltasToRemove);
        if (!patch.isEmpty()) {
            patches.put(null, patch);
        }
    }
}

