/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.diff.script.internal;

import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.annotation.InstantiationStrategy;
import org.xwiki.component.descriptor.ComponentInstantiationStrategy;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.diff.xml.StringSplitter;
import org.xwiki.diff.xml.XMLDiffFilter;
import org.xwiki.diff.xml.internal.HTMLDiffConfiguration;

@Component
@Named(value="html/script")
@InstantiationStrategy(value=ComponentInstantiationStrategy.PER_LOOKUP)
public class ScriptHTMLDiffConfiguration
extends HTMLDiffConfiguration {
    @Inject
    private Logger logger;
    @Inject
    @Named(value="context")
    private Provider<ComponentManager> componentManagerProvider;

    public ScriptHTMLDiffConfiguration setSplitterForNodeType(short nodeType, String splitterHint) {
        try {
            this.setSplitterForNodeType(nodeType, (StringSplitter)((ComponentManager)this.componentManagerProvider.get()).getInstance(StringSplitter.class, splitterHint));
        }
        catch (ComponentLookupException e) {
            this.logger.error("Failed to lookup StringSplitter with hint [{}].", (Object)splitterHint, (Object)e);
        }
        return this;
    }

    public ScriptHTMLDiffConfiguration addFilter(String filterHint) {
        try {
            this.getFilters().add((XMLDiffFilter)((ComponentManager)this.componentManagerProvider.get()).getInstance(XMLDiffFilter.class, filterHint));
        }
        catch (ComponentLookupException e) {
            this.logger.error("Failed to lookup XMLDiffFilter with hint [{}].", (Object)filterHint, (Object)e);
        }
        return this;
    }
}

