/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.diff.script;

import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.diff.DiffException;
import org.xwiki.diff.xml.XMLDiffConfiguration;
import org.xwiki.diff.xml.XMLDiffManager;
import org.xwiki.script.service.ScriptService;
import org.xwiki.stability.Unstable;

@Component
@Named(value="diff.html")
@Singleton
public class DiffHTMLScriptService
implements ScriptService {
    @Inject
    @Named(value="html/unified")
    private XMLDiffManager unifiedHTMLDiffManager;
    @Inject
    @Named(value="html/script")
    private Provider<XMLDiffConfiguration> configurationProvider;

    public String unified(String previousHTML, String nextHTML) {
        return this.unified(previousHTML, nextHTML, this.getDefaultConfiguration());
    }

    @Unstable
    public String unified(String previousHTML, String nextHTML, XMLDiffConfiguration config) {
        try {
            return this.unifiedHTMLDiffManager.diff(previousHTML, nextHTML, config);
        }
        catch (DiffException e) {
            return null;
        }
    }

    @Unstable
    public XMLDiffConfiguration getDefaultConfiguration() {
        return (XMLDiffConfiguration)this.configurationProvider.get();
    }
}

