/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.diff.display;

import java.util.List;
import org.xwiki.diff.Chunk;
import org.xwiki.diff.Conflict;
import org.xwiki.stability.Unstable;

@Unstable
public class UnifiedDiffConflictElement<E> {
    private Conflict<E> conflict;

    public UnifiedDiffConflictElement(Conflict<E> conflict) {
        this.conflict = conflict;
    }

    private List<E> getElementsFromChunk(Chunk<E> chunk) {
        return chunk.getElements();
    }

    public List<E> getPreviousElement() {
        Chunk previousChunk = this.conflict.getDeltaCurrent().getPrevious();
        return this.getElementsFromChunk(previousChunk);
    }

    public List<E> getNextElement() {
        Chunk nextChunk = this.conflict.getDeltaNext().getNext();
        return this.getElementsFromChunk(nextChunk);
    }

    public List<E> getCurrentElement() {
        Chunk currentChunk = this.conflict.getDeltaCurrent().getNext();
        return this.getElementsFromChunk(currentChunk);
    }

    public String getReference() {
        return this.conflict.getReference();
    }
}

