/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.diff.display;

import org.xwiki.diff.Chunk;
import org.xwiki.diff.Conflict;
import org.xwiki.stability.Unstable;

@Unstable
public class UnifiedDiffConflictElement<E> {
    private Conflict<E> conflict;
    private int elementIndex;

    public UnifiedDiffConflictElement(Conflict<E> conflict, int elementIndex) {
        this.conflict = conflict;
        this.elementIndex = elementIndex;
    }

    private E getElementFromChunk(Chunk<E> chunk) {
        int occurenceIndex = this.elementIndex - chunk.getIndex();
        if (occurenceIndex < 0 || occurenceIndex > chunk.getLastIndex()) {
            return null;
        }
        return chunk.getElements().get(occurenceIndex);
    }

    public E getPreviousElement() {
        Chunk previousChunk = this.conflict.getDeltaCurrent().getPrevious();
        return this.getElementFromChunk(previousChunk);
    }

    public E getNextElement() {
        Chunk nextChunk = this.conflict.getDeltaNext().getNext();
        return this.getElementFromChunk(nextChunk);
    }

    public E getCurrentElement() {
        Chunk currentChunk = this.conflict.getDeltaCurrent().getNext();
        return this.getElementFromChunk(currentChunk);
    }
}

