/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.diff.display;

import java.util.List;
import org.xwiki.diff.Conflict;
import org.xwiki.diff.display.InlineDiffChunk;
import org.xwiki.diff.display.UnifiedDiffConflictElement;
import org.xwiki.stability.Unstable;

public class UnifiedDiffElement<E, F> {
    private final int index;
    private final Type type;
    private final E value;
    private List<InlineDiffChunk<F>> chunks;
    private UnifiedDiffConflictElement<E> conflict;

    public UnifiedDiffElement(int index, Type type, E value) {
        this(index, type, value, null);
    }

    @Unstable
    public UnifiedDiffElement(int index, Type type, E value, Conflict<E> conflict) {
        this.index = index;
        this.type = type;
        this.value = value;
        if (conflict != null) {
            this.conflict = new UnifiedDiffConflictElement<E>(conflict, index);
        }
    }

    public int getIndex() {
        return this.index;
    }

    public Type getType() {
        return this.type;
    }

    public E getValue() {
        return this.value;
    }

    public List<InlineDiffChunk<F>> getChunks() {
        return this.chunks;
    }

    public void setChunks(List<InlineDiffChunk<F>> chunks) {
        this.chunks = chunks;
    }

    public boolean isAdded() {
        return this.type == Type.ADDED;
    }

    public boolean isDeleted() {
        return this.type == Type.DELETED;
    }

    @Unstable
    public boolean isConflicting() {
        return this.conflict != null;
    }

    @Unstable
    public UnifiedDiffConflictElement<E> getConflict() {
        return this.conflict;
    }

    public String toString() {
        return this.type.getSymbol() + String.valueOf(this.value) + '\n';
    }

    public static enum Type {
        ADDED('+'),
        DELETED('-'),
        CONTEXT(' ');

        private final char symbol;

        private Type(char symbol) {
            this.symbol = symbol;
        }

        public char getSymbol() {
            return this.symbol;
        }
    }
}

