/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.diff.internal;

import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.xwiki.diff.Chunk;
import org.xwiki.diff.Conflict;
import org.xwiki.diff.Delta;
import org.xwiki.text.XWikiToStringBuilder;

public class DefaultConflict<E>
implements Conflict<E> {
    private int index;
    private Delta<E> deltaCurrent;
    private Delta<E> deltaNext;

    public DefaultConflict(int index, Delta<E> current, Delta<E> next) {
        this.index = index;
        this.deltaCurrent = current;
        this.deltaNext = next;
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    @Override
    public Delta<E> getDeltaCurrent() {
        return this.deltaCurrent;
    }

    @Override
    public Delta<E> getDeltaNext() {
        return this.deltaNext;
    }

    @Override
    public boolean concerns(Chunk<E> chunk) {
        if (chunk != null) {
            return chunk.isOverlappingWith(this.getDeltaCurrent().getPrevious()) || chunk.isOverlappingWith(this.getDeltaCurrent().getNext()) || chunk.isOverlappingWith(this.getDeltaNext().getNext()) || chunk.isOverlappingWith(this.getDeltaNext().getPrevious());
        }
        return false;
    }

    @Override
    public boolean concerns(Delta<E> delta) {
        if (delta != null) {
            return this.concerns(delta.getPrevious()) || this.concerns(delta.getNext());
        }
        return false;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (object.getClass() != this.getClass()) {
            return false;
        }
        DefaultConflict otherConflict = (DefaultConflict)object;
        return new EqualsBuilder().append(this.index, otherConflict.index).append(this.deltaCurrent, otherConflict.deltaCurrent).append(this.deltaNext, otherConflict.deltaNext).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(23, 13).append(this.index).append(this.deltaCurrent).append(this.deltaNext).toHashCode();
    }

    public String toString() {
        XWikiToStringBuilder builder = new XWikiToStringBuilder((Object)this);
        builder.append("Index", this.index);
        builder.append("Delta Current", this.deltaCurrent);
        builder.append("Delta Next", this.deltaNext);
        return builder.toString();
    }
}

