/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.diff;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.xwiki.diff.ConflictDecision;

public class MergeConfiguration<E>
extends HashMap<String, Object> {
    public static final String KEY_FALLBACKONCONFLICT = "fallbackonconflict";
    private static final long serialVersionUID = 1L;
    private List<ConflictDecision<E>> conflictDecisionList;

    public MergeConfiguration(List<ConflictDecision<E>> conflictDecisions) {
        this(Version.CURRENT, conflictDecisions);
    }

    public MergeConfiguration(Version version, List<ConflictDecision<E>> conflictDecisions) {
        this.setFallbackOnConflict(version);
        this.setConflictDecisionList(conflictDecisions);
    }

    public MergeConfiguration() {
        this(new ArrayList<ConflictDecision<E>>());
    }

    public void setFallbackOnConflict(Version version) {
        this.put(KEY_FALLBACKONCONFLICT, version);
    }

    public Version getFallbackOnConflict() {
        return this.containsKey(KEY_FALLBACKONCONFLICT) ? (Version)((Object)this.get(KEY_FALLBACKONCONFLICT)) : Version.CURRENT;
    }

    public List<ConflictDecision<E>> getConflictDecisionList() {
        return this.conflictDecisionList;
    }

    public void setConflictDecisionList(List<ConflictDecision<E>> conflictDecisionList) {
        this.conflictDecisionList = new ArrayList<ConflictDecision<ConflictDecision<E>>>(conflictDecisionList);
    }

    public static enum Version {
        PREVIOUS,
        NEXT,
        CURRENT;

    }
}

